/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.retrieve;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ivyde.eclipse.cp.RetrieveSetup;
import org.apache.ivyde.eclipse.cp.SettingsSetup;
import org.apache.ivyde.internal.eclipse.retrieve.StandaloneRetrieveSetup;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StandaloneRetrieveSerializer {
    private static final String ROOT = "setuplist";
    private static final String SETUP = "setup";
    private static final String SETUP_NAME = "name";
    private static final String IVYSETTINGS = "ivysettings";
    private static final String IVYSETTING_PATH = "path";
    private static final String IVYSETTING_LOADONDEMAND = "loadondemand";
    private static final String IVY_USER_DIR = "ivyUserDir";
    private static final String PROPERTYFILE = "propertyfile";
    private static final String PROPERTYFILE_PATH = "path";
    private static final String IVYXML = "ivyxml";
    private static final String IVYXML_PATH = "path";
    private static final String RETRIEVE = "retrieve";
    private static final String RETRIEVE_SYNC = "sync";
    private static final String RETRIEVE_TYPES = "types";
    private static final String RETRIEVE_CONFS = "confs";
    private static final String RETRIEVE_PATTERN = "pattern";
    private static final String RESOLVE_IN_WORKSPACE = "resolveInWorkspace";

    public void write(OutputStream out, List setuplist) throws IOException {
        try {
            StreamResult result = new StreamResult(out);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(ROOT);
            document.appendChild(root);
            Iterator it = setuplist.iterator();
            while (it.hasNext()) {
                StandaloneRetrieveSetup setup = (StandaloneRetrieveSetup)it.next();
                Element node = document.createElement(SETUP);
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                Attr attr = document.createAttribute(SETUP_NAME);
                attr.setValue(setup.getName());
                attributes.setNamedItem(attr);
                attr = document.createAttribute(RESOLVE_IN_WORKSPACE);
                attr.setValue(Boolean.toString(setup.isResolveInWorkspace()));
                attributes.setNamedItem(attr);
                if (setup.isSettingProjectSpecific()) {
                    Element settingsNode = document.createElement(IVYSETTINGS);
                    node.appendChild(settingsNode);
                    this.writeSettingsSetup(document, settingsNode, setup.getSettingsSetup());
                }
                Element ivyxmlNode = document.createElement(IVYXML);
                node.appendChild(ivyxmlNode);
                this.writeIvyXmlPath(document, ivyxmlNode, setup.getIvyXmlPath());
                Element retrieveNode = document.createElement(RETRIEVE);
                node.appendChild(retrieveNode);
                this.writeRetrieveSetup(document, retrieveNode, setup.getRetrieveSetup());
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void writeSettingsSetup(Document document, Node settingsNode, SettingsSetup settingsSetup) {
        NamedNodeMap attributes = settingsNode.getAttributes();
        Attr attr = document.createAttribute("path");
        attr.setValue(settingsSetup.getRawIvySettingsPath());
        attributes.setNamedItem(attr);
        attr = document.createAttribute(IVYSETTING_LOADONDEMAND);
        attr.setValue(Boolean.toString(settingsSetup.isLoadSettingsOnDemand()));
        attributes.setNamedItem(attr);
        attr = document.createAttribute(IVY_USER_DIR);
        attr.setValue(settingsSetup.getRawIvyUserDir());
        attributes.setNamedItem(attr);
        Iterator it = settingsSetup.getRawPropertyFiles().iterator();
        while (it.hasNext()) {
            String file = (String)it.next();
            Element pathNode = document.createElement(PROPERTYFILE);
            settingsNode.appendChild(pathNode);
            attributes = pathNode.getAttributes();
            attr = document.createAttribute("path");
            attr.setValue(file);
            attributes.setNamedItem(attr);
        }
    }

    private void writeIvyXmlPath(Document document, Node ivyxmlNode, String ivyXmlPath) {
        NamedNodeMap attributes = ivyxmlNode.getAttributes();
        Attr attr = document.createAttribute("path");
        attr.setValue(ivyXmlPath);
        attributes.setNamedItem(attr);
    }

    private void writeRetrieveSetup(Document document, Node retrieveNode, RetrieveSetup retrieveSetup) {
        NamedNodeMap attributes = retrieveNode.getAttributes();
        Attr attr = document.createAttribute(RETRIEVE_PATTERN);
        attr.setValue(retrieveSetup.getRetrievePattern());
        attributes.setNamedItem(attr);
        attr = document.createAttribute(RETRIEVE_CONFS);
        attr.setValue(retrieveSetup.getRetrieveConfs());
        attributes.setNamedItem(attr);
        attr = document.createAttribute(RETRIEVE_TYPES);
        attr.setValue(retrieveSetup.getRetrieveTypes());
        attributes.setNamedItem(attr);
        attr = document.createAttribute(RETRIEVE_SYNC);
        attr.setValue(Boolean.toString(retrieveSetup.isRetrieveSync()));
        attributes.setNamedItem(attr);
    }

    public List read(InputStream in, IProject project) throws IOException {
        try {
            InputSource source = new InputSource(in);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(source);
            NodeList elements = document.getElementsByTagName(SETUP);
            ArrayList<StandaloneRetrieveSetup> setupList = new ArrayList<StandaloneRetrieveSetup>();
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                StandaloneRetrieveSetup setup = new StandaloneRetrieveSetup();
                setup.setProject(project);
                NamedNodeMap attributes = node.getAttributes();
                setup.setName(this.getAttribute(attributes, SETUP_NAME));
                Node attr = attributes.getNamedItem(RESOLVE_IN_WORKSPACE);
                if (attr != null) {
                    setup.setResolveInWorkspace(Boolean.valueOf(attr.getNodeValue()));
                }
                NodeList children = node.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    Node item = children.item(j);
                    if (item.getNodeName().equals(IVYSETTINGS)) {
                        SettingsSetup settingsSetup = this.readSettingsSetup(item);
                        setup.setSettingsSetup(settingsSetup);
                        setup.setSettingsProjectSpecific(true);
                    } else if (item.getNodeName().equals(IVYXML)) {
                        String ivyXmlPath = this.readIvyXmlPath(item);
                        setup.setIvyXmlPath(ivyXmlPath);
                    } else if (item.getNodeName().equals(RETRIEVE)) {
                        RetrieveSetup retrieveSetup = this.readRetrieveSetup(item);
                        setup.setRetrieveSetup(retrieveSetup);
                    }
                    ++j;
                }
                setupList.add(setup);
                ++i;
            }
            return setupList;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t == null) {
                t = e;
            }
            IOException ioe = new IOException(t.getMessage());
            ioe.initCause(t);
            throw ioe;
        }
    }

    private String getAttribute(NamedNodeMap attributes, String name) throws SAXException {
        Node node = attributes.getNamedItem(name);
        if (node == null) {
            throw new SAXException("Attribute '" + name + "' not found");
        }
        return node.getNodeValue();
    }

    private SettingsSetup readSettingsSetup(Node node) throws SAXException {
        NamedNodeMap attributes = node.getAttributes();
        SettingsSetup settingsSetup = new SettingsSetup();
        String path = this.getAttribute(attributes, "path");
        settingsSetup.setIvySettingsPath(path);
        String loadOnDemand = this.getAttribute(attributes, IVYSETTING_LOADONDEMAND);
        settingsSetup.setLoadSettingsOnDemand(Boolean.valueOf(loadOnDemand));
        String ivyUserDir = this.getAttribute(attributes, IVY_USER_DIR);
        settingsSetup.setIvyUserDir(ivyUserDir);
        ArrayList<String> propertyFiles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j != children.getLength()) {
            Node item = children.item(j);
            if (item.getNodeName().equals(PROPERTYFILE)) {
                attributes = item.getAttributes();
                path = this.getAttribute(attributes, "path");
                propertyFiles.add(path);
            }
            ++j;
        }
        settingsSetup.setPropertyFiles(propertyFiles);
        return settingsSetup;
    }

    private String readIvyXmlPath(Node node) throws SAXException {
        NamedNodeMap attributes = node.getAttributes();
        return this.getAttribute(attributes, "path");
    }

    private RetrieveSetup readRetrieveSetup(Node node) throws SAXException {
        NamedNodeMap attributes = node.getAttributes();
        RetrieveSetup retrieveSetup = new RetrieveSetup();
        String pattern = this.getAttribute(attributes, RETRIEVE_PATTERN);
        retrieveSetup.setRetrievePattern(pattern);
        String confs = this.getAttribute(attributes, RETRIEVE_CONFS);
        retrieveSetup.setRetrieveConfs(confs);
        String types = this.getAttribute(attributes, RETRIEVE_TYPES);
        retrieveSetup.setRetrieveTypes(types);
        String sync = this.getAttribute(attributes, RETRIEVE_SYNC);
        retrieveSetup.setRetrieveSync(Boolean.valueOf(sync));
        return retrieveSetup;
    }
}

