/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivyde.internal.eclipse.ui.PathEditorDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FileListEditor
extends Composite {
    private ListViewer filelist;
    private List files = new ArrayList();
    private Button edit;
    private Button add;
    private Button remove;
    private Button up;
    private Button down;

    public FileListEditor(Composite parent, int style, String label, final String labelPopup, final IProject project, final String defaultExtension) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label((Composite)this, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(1, 4, false, false));
        this.filelist = new ListViewer((Composite)this, 2048);
        this.filelist.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.filelist.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.filelist.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.filelist.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileListEditor.this.edit.setEnabled(!event.getSelection().isEmpty());
                FileListEditor.this.remove.setEnabled(!event.getSelection().isEmpty());
                FileListEditor.this.updateUpDownEnableButtons(true);
            }
        });
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.edit = new Button(buttons, 8);
        this.edit.setText("Edit");
        this.edit.setLayoutData((Object)new GridData(4, 1, true, false));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEditorDialog dialog = new PathEditorDialog(FileListEditor.this.getShell(), labelPopup, project, defaultExtension);
                String selection = (String)((IStructuredSelection)FileListEditor.this.filelist.getSelection()).getFirstElement();
                dialog.init(selection);
                if (dialog.open() == 0) {
                    int i = FileListEditor.this.getSelectedConfigurationIndex(selection);
                    FileListEditor.this.files.set(i, dialog.getFile());
                    FileListEditor.this.filelist.refresh();
                    FileListEditor.this.fileListUpdated();
                }
            }
        });
        this.add = new Button(buttons, 8);
        this.add.setText("Add");
        this.add.setLayoutData((Object)new GridData(4, 1, true, false));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEditorDialog dialog = new PathEditorDialog(FileListEditor.this.getShell(), labelPopup, project, defaultExtension);
                if (dialog.open() == 0) {
                    FileListEditor.this.files.add(dialog.getFile());
                    FileListEditor.this.filelist.refresh();
                    FileListEditor.this.fileListUpdated();
                }
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setText("Remove");
        this.remove.setLayoutData((Object)new GridData(4, 1, true, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ((IStructuredSelection)FileListEditor.this.filelist.getSelection()).toList();
                FileListEditor.this.files.removeAll(selection);
                FileListEditor.this.filelist.refresh();
                FileListEditor.this.fileListUpdated();
                FileListEditor.this.remove.setEnabled(false);
                FileListEditor.this.edit.setEnabled(false);
            }
        });
        this.up = new Button(buttons, 8);
        this.up.setText("Up");
        this.up.setLayoutData((Object)new GridData(4, 1, true, false));
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = FileListEditor.this.getSelectedConfigurationIndex();
                String f = (String)FileListEditor.this.files.get(i);
                FileListEditor.this.files.set(i, FileListEditor.this.files.get(i - 1));
                FileListEditor.this.files.set(i - 1, f);
                FileListEditor.this.filelist.refresh();
                FileListEditor.this.fileListUpdated();
                FileListEditor.this.updateUpDownEnableButtons(true);
            }
        });
        this.down = new Button(buttons, 8);
        this.down.setText("Down");
        this.down.setLayoutData((Object)new GridData(4, 1, true, false));
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = FileListEditor.this.getSelectedConfigurationIndex();
                String f = (String)FileListEditor.this.files.get(i);
                FileListEditor.this.files.set(i, FileListEditor.this.files.get(i + 1));
                FileListEditor.this.files.set(i + 1, f);
                FileListEditor.this.filelist.refresh();
                FileListEditor.this.fileListUpdated();
                FileListEditor.this.updateUpDownEnableButtons(true);
            }
        });
    }

    private int getSelectedConfigurationIndex() {
        IStructuredSelection selection = (IStructuredSelection)this.filelist.getSelection();
        String file = (String)selection.getFirstElement();
        return this.getSelectedConfigurationIndex(file);
    }

    private int getSelectedConfigurationIndex(String file) {
        int i = 0;
        while (i < this.files.size()) {
            if (this.files.get(i) == file) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateUpDownEnableButtons(boolean enabled) {
        boolean selected = this.filelist.getList().getSelectionCount() != 0;
        int i = this.getSelectedConfigurationIndex();
        this.up.setEnabled(enabled && selected && i > 0);
        this.down.setEnabled(enabled && selected && i < this.files.size() - 1);
    }

    public void init(List files) {
        this.files = files;
        this.filelist.setInput((Object)files);
        this.remove.setEnabled(false);
        this.edit.setEnabled(false);
    }

    protected void fileListUpdated() {
    }

    public List getFiles() {
        return this.files;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.filelist.getList().setEnabled(enabled);
        this.edit.setEnabled(enabled && !this.filelist.getSelection().isEmpty());
        this.remove.setEnabled(enabled && !this.filelist.getSelection().isEmpty());
        this.add.setEnabled(enabled);
        this.updateUpDownEnableButtons(enabled);
    }
}

