/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PathEditor
extends Composite {
    private Text text;
    private Button variableButton;
    private Button browseFileSystem;
    private Button browseWorkspace;
    private final IProject project;
    private final String defaultExtension;
    private Button browseProject;

    public PathEditor(Composite parent, int style, String label, IProject project, String defaultExtension) {
        super(parent, style);
        this.project = project;
        this.defaultExtension = defaultExtension;
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        Label l = new Label((Composite)this, 0);
        l.setText(label);
        this.text = this.createText(this);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathEditor.this.textUpdated();
            }
        });
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        layout = new GridLayout(project == null ? 4 : 5, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        boolean added = this.addButtons(buttons);
        if (project != null) {
            this.browseProject = new Button(buttons, 0);
            this.browseProject.setLayoutData((Object)new GridData(3, 2, !added, false));
            this.browseProject.setText("Project...");
            this.browseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PathEditor.this.selectInProject();
                }
            });
        }
        this.browseWorkspace = new Button(buttons, 0);
        this.browseWorkspace.setLayoutData((Object)new GridData(project == null ? 3 : 2, 2, !added && project == null, false));
        this.browseWorkspace.setText("Workspace...");
        this.browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEditor.this.selectInWorkspace();
            }
        });
        this.browseFileSystem = new Button(buttons, 0);
        this.browseFileSystem.setLayoutData((Object)new GridData(2, 2, false, false));
        this.browseFileSystem.setText("File System...");
        this.browseFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEditor.this.selectInFileSystem();
            }
        });
        this.variableButton = new Button(buttons, 0);
        this.variableButton.setLayoutData((Object)new GridData(2, 2, false, false));
        this.variableButton.setText("Variables...");
        this.variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathEditor.this.selectVariable();
            }
        });
    }

    private void selectInProject() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Select a file in the project:");
        dialog.setMessage("Select a file in the project:");
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).getName().equals(PathEditor.this.project.getName());
                }
                if (PathEditor.this.defaultExtension == null) {
                    return element instanceof IContainer;
                }
                return true;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IResource) {
            IPath path = ((IResource)results[0]).getFullPath();
            this.setProjectLoc(path.removeFirstSegments(1).makeRelative().toString());
        }
    }

    private void selectInWorkspace() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Select a file in the workspace:");
        dialog.setMessage("Select a file in the workspace:");
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).isAccessible();
                }
                if (PathEditor.this.defaultExtension == null) {
                    return element instanceof IContainer;
                }
                return true;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IResource) {
            IPath path = ((IResource)results[0]).getFullPath();
            if (this.project != null && path.segment(0).equals(this.project.getProject().getName())) {
                this.setProjectLoc(path.removeFirstSegments(1).makeRelative().toString());
            } else {
                String containerName = path.makeRelative().toString();
                this.setWorkspaceLoc("${workspace_loc:" + containerName + "}");
            }
        }
    }

    private void selectInFileSystem() {
        String file;
        if (this.defaultExtension == null) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
            file = dialog.open();
        } else {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            if (this.text != null) {
                dialog.setFileName(this.text.getText());
            }
            dialog.setFilterExtensions(new String[]{this.defaultExtension, "*"});
            file = dialog.open();
        }
        if (file != null) {
            this.setFile(file);
        }
    }

    private void selectVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variable = dialog.getVariableExpression();
        if (variable != null) {
            this.addVariable(variable);
        }
    }

    protected void addVariable(String variable) {
        this.text.insert(variable);
        this.textUpdated();
    }

    protected void setFile(String file) {
        this.text.setText(file);
        this.textUpdated();
    }

    protected void setProjectLoc(String projectLoc) {
        this.text.setText(projectLoc);
        this.textUpdated();
    }

    protected void setWorkspaceLoc(String workspaceLoc) {
        this.text.setText(workspaceLoc);
        this.textUpdated();
    }

    protected void textUpdated() {
    }

    protected Text createText(Composite parent) {
        Text t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(4, 2, true, false));
        return t;
    }

    protected boolean addButtons(Composite buttons) {
        return false;
    }

    public Text getText() {
        return this.text;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        if (this.browseProject != null) {
            this.browseProject.setEnabled(enabled);
        }
        this.browseFileSystem.setEnabled(enabled);
        this.browseWorkspace.setEnabled(enabled);
        this.variableButton.setEnabled(enabled);
    }
}

