/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.SettingsSetup;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.FileListEditor;
import org.apache.ivyde.internal.eclipse.ui.PathEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SettingsSetupEditor
extends Composite {
    public static final String TOOLTIP_SETTINGS_PATH = "The url where your ivysettings file can be found. \nLeave it empty to reference the default ivy settings. \nRelative paths are handled relative to the project.";
    public static final String TOOLTIP_PROPERTY_FILES = "Comma separated list of build property files.\nExample: build.properties, override.properties";
    private final List listeners = new ArrayList();
    private IvyDEException settingsError;
    private FieldDecoration errorDecoration;
    private FileListEditor propFilesEditor;
    private DecoratedField settingsTextDeco;
    private Button loadOnDemandButton;
    private PathEditor settingsEditor;
    private Button defaultButton;
    private PathEditor ivyUserDirEditor;

    public SettingsSetupEditor(Composite parent, int style, IProject project) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.loadOnDemandButton = new Button((Composite)this, 32);
        this.loadOnDemandButton.setText("reload the settings only on demand");
        this.loadOnDemandButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.settingsEditor = new PathEditor(this, 0, "Ivy settings path:", project, "*.xml"){

            protected Text createText(Composite parent) {
                SettingsSetupEditor.this.errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                SettingsSetupEditor.this.settingsTextDeco = new DecoratedField(parent, 16512, new IControlCreator(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Control createControl(Composite p, int s) {
                        return new Text(p, 2052);
                    }
                });
                SettingsSetupEditor.this.settingsTextDeco.addFieldDecoration(SettingsSetupEditor.this.errorDecoration, 16512, false);
                SettingsSetupEditor.this.settingsTextDeco.hideDecoration(SettingsSetupEditor.this.errorDecoration);
                Text settingsText = (Text)SettingsSetupEditor.this.settingsTextDeco.getControl();
                settingsText.setToolTipText(SettingsSetupEditor.TOOLTIP_SETTINGS_PATH);
                SettingsSetupEditor.this.settingsTextDeco.getLayoutControl().setLayoutData((Object)new GridData(4, 2, true, false));
                return settingsText;
            }

            protected boolean addButtons(Composite buttons) {
                SettingsSetupEditor.this.defaultButton = new Button(buttons, 0);
                SettingsSetupEditor.this.defaultButton.setLayoutData((Object)new GridData(3, 2, true, false));
                SettingsSetupEditor.this.defaultButton.setText("Default");
                SettingsSetupEditor.this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$1.getText().setText("");
                    }
                });
                return true;
            }

            protected void setFile(String f) {
                try {
                    this.getText().setText(new File(f).toURI().toURL().toExternalForm());
                    this.textUpdated();
                }
                catch (MalformedURLException ex) {
                    IvyPlugin.logError("The file got from the file browser has not a valid URL", ex);
                }
            }

            protected void textUpdated() {
                SettingsSetupEditor.this.settingsUpdated();
            }
        };
        this.settingsEditor.setLayoutData(new GridData(4, 4, true, false));
        this.ivyUserDirEditor = new PathEditor(this, 0, "Ivy user dir:", project, null){

            protected void textUpdated() {
                SettingsSetupEditor.this.settingsUpdated();
            }
        };
        this.ivyUserDirEditor.setLayoutData(new GridData(4, 4, true, false));
        this.propFilesEditor = new FileListEditor(this, 0, "Property files:", "Property file:", project, "*.properties"){

            protected void fileListUpdated() {
                SettingsSetupEditor.this.settingsUpdated();
            }
        };
        this.propFilesEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    public SettingsSetup getIvySettingsSetup() {
        SettingsSetup setup = new SettingsSetup();
        setup.setIvySettingsPath(this.settingsEditor.getText().getText());
        setup.setLoadSettingsOnDemand(this.loadOnDemandButton.getSelection());
        setup.setIvyUserDir(this.ivyUserDirEditor.getText().getText());
        setup.setPropertyFiles(this.propFilesEditor.getFiles());
        return setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SettingsEditorListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remodeListener(SettingsEditorListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void settingsUpdated() {
        List list = this.listeners;
        synchronized (list) {
            SettingsSetup setup = this.getIvySettingsSetup();
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((SettingsEditorListener)it.next()).settingsEditorUpdated(setup);
            }
        }
    }

    public void setSettingsError(IvyDEException error) {
        if (error == null) {
            this.settingsError = null;
            this.settingsTextDeco.hideDecoration(this.errorDecoration);
            this.settingsTextDeco.hideHover();
        } else if (!error.equals(this.settingsError)) {
            this.settingsError = error;
            this.settingsTextDeco.showDecoration(this.errorDecoration);
            if (this.settingsEditor.getText().isVisible()) {
                this.errorDecoration.setDescription(error.getShortMsg());
                this.settingsTextDeco.showHoverText(error.getShortMsg());
            }
        }
    }

    public void updateErrorMarker() {
        if (this.isVisible() && this.settingsError != null) {
            this.errorDecoration.setDescription(this.settingsError.getShortMsg());
            this.settingsTextDeco.showHoverText(this.settingsError.getShortMsg());
        } else {
            this.settingsTextDeco.hideHover();
        }
    }

    File getFile(File startingDirectory) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        String file = dialog.open();
        if (file != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    public void init(SettingsSetup setup) {
        this.settingsEditor.getText().setText(setup.getRawIvySettingsPath());
        this.propFilesEditor.init(setup.getRawPropertyFiles());
        this.ivyUserDirEditor.getText().setText(setup.getRawIvyUserDir());
        this.loadOnDemandButton.setSelection(setup.isLoadSettingsOnDemand());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.settingsEditor.setEnabled(enabled);
        this.defaultButton.setEnabled(enabled);
        this.ivyUserDirEditor.setEnabled(enabled);
        this.propFilesEditor.setEnabled(enabled);
        this.loadOnDemandButton.setEnabled(enabled);
    }

    public static interface SettingsEditorListener {
        public void settingsEditorUpdated(SettingsSetup var1);
    }
}

