/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.model.internal;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.hook.core.model.CustomJsp;
import com.liferay.ide.hook.core.model.internal.CustomJspResource;
import com.liferay.ide.hook.core.model.internal.HookListBindingImpl;
import com.liferay.ide.hook.core.model.internal.ObjectValue;
import com.liferay.ide.hook.core.util.HookUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomJspsBindingImpl
extends HookListBindingImpl {
    private List<ObjectValue<String>> customJsps;
    private IPath lastCustomJspDirPath;
    private IPath portalDir;

    protected List<?> readUnderlyingList() {
        IFile[] customJspFiles;
        IFolder customJspFolder = HookUtil.getCustomJspFolder(this.hook(), this.project());
        if (customJspFolder == null || this.portalDir == null) {
            this.lastCustomJspDirPath = null;
            return Collections.emptyList();
        }
        IPath customJspDirPath = customJspFolder.getProjectRelativePath();
        if (customJspDirPath != null && customJspDirPath.equals((Object)this.lastCustomJspDirPath)) {
            return this.customJsps;
        }
        this.customJsps = new ArrayList<ObjectValue<String>>();
        this.lastCustomJspDirPath = customJspDirPath;
        IFile[] iFileArray = customJspFiles = this.getCustomJspFiles();
        int n = customJspFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile customJspFile = iFileArray[n2];
            IPath customJspFilePath = customJspFile.getProjectRelativePath();
            IPath customJspPath = customJspFilePath.removeFirstSegments(customJspFilePath.matchingFirstSegments(customJspDirPath));
            this.customJsps.add(new ObjectValue<String>(customJspPath.toPortableString()));
            ++n2;
        }
        return this.customJsps;
    }

    protected Resource resource(Object obj) {
        return new CustomJspResource(this.property().element().resource(), (ObjectValue)obj);
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        ObjectValue retval = null;
        if (type.equals(CustomJsp.TYPE)) {
            retval = new ObjectValue();
            this.customJsps.add(retval);
        }
        return retval;
    }

    private void findJspFiles(IFolder folder, List<IFile> jspFiles) throws CoreException {
        IResource[] members;
        if (folder == null || !folder.exists()) {
            return;
        }
        IResource[] iResourceArray = members = folder.members(3);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IFile && "jsp".equals(member.getFileExtension())) {
                jspFiles.add((IFile)member);
            } else if (member instanceof IFolder) {
                this.findJspFiles((IFolder)member, jspFiles);
            }
            ++n2;
        }
    }

    private IFile[] getCustomJspFiles() {
        ArrayList<IFile> customJspFiles = new ArrayList<IFile>();
        IFolder customJspFolder = HookUtil.getCustomJspFolder(this.hook(), this.project());
        try {
            this.findJspFiles(customJspFolder, customJspFiles);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return customJspFiles.toArray(new IFile[0]);
    }

    public void init(Property property) {
        super.init(property);
        ILiferayProject liferayProject = LiferayCore.create((Object)this.project());
        if (liferayProject != null) {
            this.portalDir = liferayProject.getAppServerPortalDir();
        }
    }

    public void remove(Resource resource) {
        ObjectValue<String> customJsp = ((CustomJspResource)((Object)resource.adapt(CustomJspResource.class))).getCustomJsp();
        this.customJsps.remove(customJsp);
    }

    public ElementType type(Resource resource) {
        if (resource instanceof CustomJspResource) {
            return CustomJsp.TYPE;
        }
        return null;
    }
}

