/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.cmd;

import com.liferay.ide.layouttpl.core.model.ModelElement;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import com.liferay.ide.layouttpl.core.model.PortletRowLayoutElement;
import com.liferay.ide.layouttpl.ui.model.LayoutConstraint;
import com.liferay.ide.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.layouttpl.ui.util.LayoutTplUIUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.osgi.util.NLS;

public class PortletColumnCreateCommand
extends Command {
    protected PortletRowLayoutElement rowLayout;
    protected LayoutConstraint layoutConstraint;
    protected PortletColumn newColumn;
    protected int refColumnOldWeight = 0;

    public PortletColumnCreateCommand(PortletColumn newColumn, PortletRowLayoutElement rowLayout, LayoutConstraint constraint) {
        this.newColumn = newColumn;
        this.rowLayout = rowLayout;
        this.layoutConstraint = constraint;
        this.setLabel(Msgs.portletColumnAdded);
    }

    public boolean canExecute() {
        return this.newColumn != null && this.rowLayout != null && this.layoutConstraint != null;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.layoutConstraint.equals(LayoutConstraint.EMPTY) || this.layoutConstraint.newColumnIndex == -1) {
            PortletLayout portletLayout = new PortletLayout();
            this.newColumn.setWeight(100);
            portletLayout.addColumn(this.newColumn);
            this.rowLayout.addRow((PortletLayoutElement)portletLayout, this.layoutConstraint.newRowIndex);
        } else if (this.layoutConstraint.rowIndex > -1 && this.layoutConstraint.newColumnIndex > -1) {
            if (this.layoutConstraint.refColumn != null) {
                this.refColumnOldWeight = this.layoutConstraint.refColumn.getWeight();
                int newRefWeight = this.refColumnOldWeight - this.layoutConstraint.weight - 1;
                this.layoutConstraint.refColumn.setWeight(LayoutTplUIUtil.adjustWeight(newRefWeight));
            }
            this.newColumn.setWeight(this.layoutConstraint.weight);
            ModelElement row = (ModelElement)this.rowLayout.getRows().get(this.layoutConstraint.rowIndex);
            PortletLayout portletLayout = (PortletLayout)row;
            if (row != null) {
                portletLayout.addColumn(this.newColumn, this.layoutConstraint.newColumnIndex);
            }
        }
    }

    public void undo() {
        if (this.layoutConstraint.equals(LayoutConstraint.EMPTY) || this.layoutConstraint.newColumnIndex == -1) {
            for (ModelElement row : this.rowLayout.getRows()) {
                PortletLayout portletLayout = (PortletLayout)row;
                if (portletLayout.getColumns().size() != 1 || !((ModelElement)portletLayout.getColumns().get(0)).equals((Object)this.newColumn)) continue;
                this.rowLayout.removeRow((PortletLayoutElement)portletLayout);
                break;
            }
        } else if (this.layoutConstraint.rowIndex > -1 && this.layoutConstraint.newColumnIndex > -1) {
            if (this.layoutConstraint.refColumn != null) {
                this.layoutConstraint.refColumn.setWeight(this.refColumnOldWeight);
            }
            ModelElement row = (ModelElement)this.rowLayout.getRows().get(this.layoutConstraint.rowIndex);
            PortletLayout portletLayout = (PortletLayout)row;
            if (row != null) {
                portletLayout.removeColumn(this.newColumn);
            }
        }
    }

    private static class Msgs
    extends NLS {
        public static String portletColumnAdded;

        static {
            Msgs.initializeMessages((String)PortletColumnCreateCommand.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

