/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.NodeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertiesUtil {
    public static void encodeLanguagePropertiesFilesToDefault(IProject proj, IProgressMonitor monitor) {
        IFile[] languagePropertiesFiles;
        IFile[] iFileArray = languagePropertiesFiles = PropertiesUtil.getLanguagePropertiesFiles(proj);
        int n = languagePropertiesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            try {
                if (!"UTF-8".equals(file.getCharset())) {
                    file.setCharset(null, monitor);
                    file.setContents(file.getContents(), 1, monitor);
                }
            }
            catch (Exception e) {
                LiferayCore.logError(e);
            }
            ++n2;
        }
    }

    private static LanguageFileInfo getLanguageFileInfo(IFile liferayHookXml) {
        LanguageFileInfo retval = new LanguageFileInfo();
        try {
            IDOMDocument document;
            NodeList languagePropertiesList;
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(liferayHookXml);
            if (model instanceof IDOMModel && (languagePropertiesList = (document = ((IDOMModel)model).getDocument()).getElementsByTagName("language-properties")).getLength() > 0) {
                int i = 0;
                while (i < languagePropertiesList.getLength()) {
                    Node languageProperties = languagePropertiesList.item(i);
                    String languagePropertiesVal = NodeUtil.getTextContent(languageProperties);
                    retval.addLanguagePropertiesValue(languagePropertiesVal);
                    ++i;
                }
            }
            model.releaseFromRead();
        }
        catch (Exception exception) {}
        return retval;
    }

    public static IFile[] getLanguagePropertiesFiles(IProject proj) {
        int n;
        IFolder[] iFolderArray;
        int n2;
        int n3;
        String[] stringArray;
        HashSet<IFile> retval = new HashSet<IFile>();
        if (!CoreUtil.isLiferayProject(proj)) {
            return new IFile[0];
        }
        IFolder[] srcFolders = CoreUtil.getSrcFolders(proj);
        if (srcFolders.length < 1) {
            return new IFile[0];
        }
        IFile portletXml = null;
        IFile liferayHookXml = null;
        IWorkspaceRoot root = CoreUtil.getWorkspaceRoot();
        IFolder defaultDocrootFolder = CoreUtil.getDefaultDocrootFolder(proj);
        if (defaultDocrootFolder != null) {
            portletXml = defaultDocrootFolder.getFile((IPath)new Path("WEB-INF/portlet.xml"));
            liferayHookXml = defaultDocrootFolder.getFile((IPath)new Path("WEB-INF/liferay-hook.xml"));
        }
        if (portletXml != null && portletXml.exists()) {
            IFolder srcFolder;
            int n4;
            ResourceNodeInfo resourceNodeInfo = PropertiesUtil.getResourceNodeInfo(portletXml);
            stringArray = resourceNodeInfo.getResourceBundleValues();
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                String resourceBundleValue = stringArray[n2];
                String resourceBundleName = String.valueOf(resourceBundleValue.replaceAll("\\.", "/")) + ".properties";
                iFolderArray = srcFolders;
                n4 = srcFolders.length;
                n = 0;
                while (n < n4) {
                    srcFolder = iFolderArray[n];
                    IFile resourceBundleFile = root.getFile(srcFolder.getFullPath().append(resourceBundleName));
                    if (resourceBundleFile.exists()) {
                        retval.add(resourceBundleFile);
                    }
                    ++n;
                }
                ++n2;
            }
            stringArray = resourceNodeInfo.getSupportedLocaleValues();
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                String supportedLocaleValue = stringArray[n2];
                String supportedLocaleName = String.valueOf(supportedLocaleValue.replaceAll("\\.", "/")) + "_" + supportedLocaleValue + ".properties";
                iFolderArray = srcFolders;
                n4 = srcFolders.length;
                n = 0;
                while (n < n4) {
                    srcFolder = iFolderArray[n];
                    IFile supportedLocaleFile = root.getFile(srcFolder.getFullPath().append(supportedLocaleName));
                    if (supportedLocaleFile.exists()) {
                        retval.add(supportedLocaleFile);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if (liferayHookXml != null && liferayHookXml.exists()) {
            LanguageFileInfo languageFileInfo = PropertiesUtil.getLanguageFileInfo(liferayHookXml);
            stringArray = languageFileInfo.getLanguagePropertyValues();
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                String languagePropertyVal = stringArray[n2];
                if (languagePropertyVal.contains("*")) {
                    String languagePropertiesValRegex = languagePropertyVal.replaceAll("\\*", ".*");
                    iFolderArray = srcFolders;
                    int n5 = srcFolders.length;
                    n = 0;
                    while (n < n5) {
                        IFolder srcFolder = iFolderArray[n];
                        IFile[] languagePropertiesFiles = PropertiesUtil.visitPropertiesFiles((IResource)srcFolder, languagePropertiesValRegex);
                        if (languagePropertiesFiles != null && languagePropertiesFiles.length > 0) {
                            IFile[] iFileArray = languagePropertiesFiles;
                            int n6 = languagePropertiesFiles.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                IFile file = iFileArray[n7];
                                if (file.exists()) {
                                    retval.add(file);
                                }
                                ++n7;
                            }
                        }
                        ++n;
                    }
                } else {
                    IFolder[] iFolderArray2 = srcFolders;
                    n = srcFolders.length;
                    int n8 = 0;
                    while (n8 < n) {
                        IFolder srcFolder = iFolderArray2[n8];
                        IFile languagePropertiesFile = root.getFile(srcFolder.getFullPath().append(languagePropertyVal));
                        if (languagePropertiesFile.exists()) {
                            retval.add(languagePropertiesFile);
                        }
                        ++n8;
                    }
                }
                ++n2;
            }
        }
        return retval.toArray(new IFile[0]);
    }

    private static ResourceNodeInfo getResourceNodeInfo(IFile portletXml) {
        ResourceNodeInfo retval = new ResourceNodeInfo();
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(portletXml);
            if (model instanceof IDOMModel) {
                IDOMDocument document = ((IDOMModel)model).getDocument();
                NodeList portlets = document.getElementsByTagName("portlet");
                NodeList allResourceBundles = document.getElementsByTagName("resource-bundle");
                NodeList allSupportedLocales = document.getElementsByTagName("supported-locale");
                if (portlets != null && portlets.getLength() > 0) {
                    int i = 0;
                    while (i < portlets.getLength()) {
                        Node portlet = portlets.item(i);
                        Node resourceBundle = null;
                        HashSet<Node> supportedLocales = new HashSet<Node>();
                        if (allResourceBundles.getLength() > 0) {
                            int j = 0;
                            while (j < allResourceBundles.getLength()) {
                                if (allResourceBundles.item(j).getParentNode().equals(portlet)) {
                                    resourceBundle = allResourceBundles.item(j);
                                }
                                ++j;
                            }
                            if (allSupportedLocales.getLength() > 0) {
                                int k = 0;
                                while (k < allSupportedLocales.getLength()) {
                                    if (allSupportedLocales.item(k).getParentNode().equals(portlet)) {
                                        supportedLocales.add(allSupportedLocales.item(k));
                                    }
                                    ++k;
                                }
                            }
                            String resourceBundleVal = NodeUtil.getTextContent(resourceBundle);
                            retval.addResourceBundle(resourceBundleVal);
                            if (supportedLocales.size() > 0) {
                                for (Node supportedLocale : supportedLocales) {
                                    String supportedLocaleVal = NodeUtil.getTextContent(supportedLocale);
                                    String supportedLocaleResourceVal = String.valueOf(resourceBundleVal.replaceAll("\\.", "/")) + "_" + supportedLocaleVal + ".properties";
                                    retval.addSupportedLocaleVal(supportedLocaleResourceVal);
                                }
                            }
                        }
                        ++i;
                    }
                }
                model.releaseFromRead();
            }
        }
        catch (Exception exception) {}
        return retval;
    }

    public static boolean hasNonDefaultEncodingLanguagePropertiesFile(IProject proj) {
        IFile[] languageFiles;
        IFile[] iFileArray = languageFiles = PropertiesUtil.getLanguagePropertiesFiles(proj);
        int n = languageFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            try {
                if (!"UTF-8".equals(file.getCharset())) {
                    return true;
                }
            }
            catch (CoreException e) {
                LiferayCore.logError(e);
            }
            ++n2;
        }
        return false;
    }

    public static IFile[] visitPropertiesFiles(IResource container, String relativePath) {
        return new PropertiesVisitor().visitPropertiesFiles(container, relativePath);
    }

    private static class LanguageFileInfo {
        private final List<String> vals = new ArrayList<String>();

        private LanguageFileInfo() {
        }

        public void addLanguagePropertiesValue(String languagePropertiesVal) {
            this.vals.add(languagePropertiesVal);
        }

        public String[] getLanguagePropertyValues() {
            return this.vals.toArray(new String[0]);
        }
    }

    private static class PropertiesVisitor
    implements IResourceProxyVisitor {
        IResource entryResource = null;
        String relativePathToEntry = null;
        Set<IFile> resources = new HashSet<IFile>();

        private PropertiesVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            String relativePath;
            if (resourceProxy.getType() == 1 && resourceProxy.getName().endsWith(".properties") && (relativePath = resourceProxy.requestFullPath().makeRelativeTo(this.entryResource.getFullPath()).toString()).matches(this.relativePathToEntry)) {
                this.resources.add((IFile)resourceProxy.requestResource());
            }
            return true;
        }

        public IFile[] visitPropertiesFiles(IResource container, String relativePath) {
            this.entryResource = container;
            this.relativePathToEntry = relativePath;
            try {
                container.accept((IResourceProxyVisitor)this, 4);
            }
            catch (CoreException e) {
                LiferayCore.logError(e);
            }
            return this.resources.toArray(new IFile[this.resources.size()]);
        }
    }

    private static class ResourceNodeInfo {
        private final List<String> resourceBundlesValues = new ArrayList<String>();
        private final List<String> supportedLocaleValues = new ArrayList<String>();

        private ResourceNodeInfo() {
        }

        public void addResourceBundle(String resourceBundleVal) {
            this.resourceBundlesValues.add(resourceBundleVal);
        }

        public void addSupportedLocaleVal(String supportedLocaleVal) {
            this.supportedLocaleValues.add(supportedLocaleVal);
        }

        public String[] getResourceBundleValues() {
            return this.resourceBundlesValues.toArray(new String[0]);
        }

        public String[] getSupportedLocaleValues() {
            return this.supportedLocaleValues.toArray(new String[0]);
        }
    }
}

