/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.core;

import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;

public abstract class SDKJob
extends Job {
    protected IProject project;

    public SDKJob(String name) {
        super(name);
    }

    protected IProject getProject() {
        return this.project;
    }

    protected SDK getSDK() {
        if (this.project == null) {
            return null;
        }
        SDK retval = null;
        IPath sdkLocation = this.project.getRawLocation().removeLastSegments(2);
        retval = SDKManager.getInstance().getSDK(sdkLocation);
        if (retval == null && (retval = SDKUtil.createSDKFromLocation(sdkLocation)) != null && retval.isValid()) {
            SDKManager.getInstance().addSDK(retval);
        }
        return retval;
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void setProject(IProject project) {
        this.project = project;
    }
}

