/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;

public final class DivideFunction
extends Function {
    public static DivideFunction create(Function a, Function b) {
        DivideFunction function = new DivideFunction();
        function.init(a, b);
        return function;
    }

    public static DivideFunction create(Number a, Number b) {
        return DivideFunction.create(Literal.create(a), Literal.create(b));
    }

    @Override
    public String name() {
        return "/";
    }

    @Override
    public boolean operator() {
        return true;
    }

    @Override
    public int precedence() {
        return 3;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                Object b;
                Object a = this.operand(0);
                if (a instanceof Value) {
                    a = ((Value)a).content();
                }
                if ((b = this.operand(1)) instanceof Value) {
                    b = ((Value)b).content();
                }
                if (a == null && b == null) {
                    return 0L;
                }
                if (a instanceof BigDecimal || b instanceof BigDecimal || a instanceof BigInteger) {
                    BigDecimal x = this.cast(a, BigDecimal.class);
                    BigDecimal y = this.cast(b, BigDecimal.class);
                    return x.divide(y, 4);
                }
                Double x = this.cast(a, Double.class);
                Double y = this.cast(b, Double.class);
                return x / y;
            }
        };
    }
}

