/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class FunctionBasedEnablementService
extends EnablementService {
    private final List<FunctionResult> functionResults = new ArrayList<FunctionResult>();

    @Override
    protected void initEnablementService() {
        ModelElementFunctionContext fnContext = new ModelElementFunctionContext(this.context(Element.class));
        Listener functionResultListener = new Listener(){

            @Override
            public void handle(Event event) {
                FunctionBasedEnablementService.this.refresh();
            }
        };
        for (Enablement annotation : this.context(PropertyDef.class).getAnnotations(Enablement.class)) {
            Function function = null;
            try {
                function = ExpressionLanguageParser.parse(annotation.expr());
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
                function = null;
            }
            if (function == null) continue;
            function = FailSafeFunction.create(function, Literal.create(Boolean.class), Literal.create(Boolean.FALSE));
            FunctionResult functionResult = function.evaluate(fnContext);
            functionResult.attach(functionResultListener);
            this.functionResults.add(functionResult);
        }
    }

    @Override
    protected EnablementServiceData compute() {
        boolean state = true;
        for (FunctionResult result : this.functionResults) {
            boolean bl = state = state && (Boolean)result.value() != false;
        }
        return new EnablementServiceData(state);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (FunctionResult result : this.functionResults) {
            try {
                result.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            return context.find(PropertyDef.class).hasAnnotation(Enablement.class);
        }
    }
}

