/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class StaticPossibleValuesService
extends PossibleValuesService {
    private String[] values;
    private String invalidValueMessageTemplate;
    private Status.Severity invalidValueSeverity;
    private boolean caseSensitive;
    private boolean ordered;

    @Override
    protected void init() {
        super.init();
        PossibleValues a = this.context(PropertyDef.class).getAnnotation(PossibleValues.class);
        this.values = a.values();
        this.invalidValueMessageTemplate = a.invalidValueMessage();
        this.invalidValueSeverity = a.invalidValueSeverity();
        this.caseSensitive = a.caseSensitive();
        this.ordered = a.ordered();
    }

    @Override
    protected void fillPossibleValues(Set<String> values) {
        String[] stringArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            values.add(value);
            ++n2;
        }
    }

    @Override
    public String getInvalidValueMessage(String invalidValue) {
        if (this.invalidValueMessageTemplate.length() > 0) {
            return MessageFormat.format(this.invalidValueMessageTemplate, invalidValue, this.context(PropertyDef.class).getLabel(true, CapitalizationType.NO_CAPS, false));
        }
        return super.getInvalidValueMessage(invalidValue);
    }

    @Override
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return this.invalidValueSeverity;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean ordered() {
        return this.ordered;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef property = context.find(PropertyDef.class);
            return (property instanceof ValueProperty || property instanceof ListProperty) && property.hasAnnotation(PossibleValues.class) && property.getAnnotation(PossibleValues.class).values().length > 0;
        }
    }
}

