/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlEnumAnnotation
extends SourceAnnotation
implements XmlEnumAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlEnum");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceXmlEnumAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter = this.buildAnnotationElementAdapter(VALUE_ADAPTER);
    private String value;
    private TextRange valueTextRange;
    private TextRange valueValidationTextRange;
    private String fullyQualifiedValueClassName;

    public SourceXmlEnumAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        super((JavaResourceModel)parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlEnum";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.value = this.buildValue(astAnnotation);
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
        this.valueValidationTextRange = this.buildValueValidationTextRange(astAnnotation);
        this.fullyQualifiedValueClassName = this.buildFullyQualifiedValueClassName(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncValue(this.buildValue(astAnnotation));
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
        this.valueValidationTextRange = this.buildValueValidationTextRange(astAnnotation);
        this.syncFullyQualifiedValueClassName(this.buildFullyQualifiedValueClassName(astAnnotation));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(Annotation astAnnotation) {
        return (String)this.valueAdapter.getValue(astAnnotation);
    }

    private TextRange buildValueTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(VALUE_ADAPTER, astAnnotation);
    }

    private TextRange buildValueValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(VALUE_ADAPTER, astAnnotation);
    }

    @Override
    public TextRange getValueTextRange() {
        return this.valueTextRange;
    }

    @Override
    public TextRange getValueValidationTextRange() {
        return this.valueValidationTextRange;
    }

    public boolean valueTouches(int pos) {
        return this.textRangeTouches(this.valueTextRange, pos);
    }

    @Override
    public String getFullyQualifiedValueClassName() {
        return this.fullyQualifiedValueClassName;
    }

    private void syncFullyQualifiedValueClassName(String name) {
        String old = this.fullyQualifiedValueClassName;
        this.fullyQualifiedValueClassName = name;
        this.firePropertyChanged("fullyQualifiedValueClassName", old, name);
    }

    private String buildFullyQualifiedValueClassName(Annotation astAnnotation) {
        return this.value == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.valueAdapter.getExpression(astAnnotation));
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return SourceXmlEnumAnnotation.buildAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }
}

