/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;
import org.eclipse.sapphire.workspace.WorkspaceFileType;

public final class CreateWorkspaceFileOpMethods {
    @Text(value="Creating file...")
    private static LocalizableText executeTaskName;

    static {
        LocalizableText.init(CreateWorkspaceFileOpMethods.class);
    }

    public static Status execute(CreateWorkspaceFileOp operation, ProgressMonitor monitor) {
        block14: {
            if (monitor == null) {
                monitor = new ProgressMonitor();
            }
            monitor.beginTask(executeTaskName.text(), 2);
            try {
                ElementType type;
                Resource resource;
                IFile newFileHandle = (IFile)operation.getFile().resolve();
                try {
                    newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    CreateWorkspaceFileOpMethods.create(newFileHandle.getParent());
                    if (newFileHandle.exists()) {
                        newFileHandle.setContents((InputStream)new ByteArrayInputStream(new byte[0]), 1, null);
                    } else {
                        newFileHandle.create((InputStream)new ByteArrayInputStream(new byte[0]), 1, null);
                    }
                }
                catch (CoreException e) {
                    Status status = StatusBridge.create((IStatus)e.getStatus());
                    monitor.done();
                    return status;
                }
                monitor.worked(1);
                WorkspaceFileType fileTypeAnnotation = (WorkspaceFileType)operation.type().getAnnotation(WorkspaceFileType.class);
                if (fileTypeAnnotation == null || (resource = (Resource)((MasterConversionService)(type = ElementType.read(fileTypeAnnotation.value())).service(MasterConversionService.class)).convert((Object)newFileHandle, Resource.class)) == null) break block14;
                try {
                    Element element = type.instantiate(resource);
                    try {
                        element.initialize();
                        resource.save();
                    }
                    finally {
                        element.dispose();
                    }
                }
                catch (ResourceStoreException e) {
                    Status status = Status.createErrorStatus((Throwable)e);
                    monitor.done();
                    return status;
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.createOkStatus();
    }

    private static void create(IContainer container) throws CoreException {
        if (!container.exists()) {
            CreateWorkspaceFileOpMethods.create(container.getParent());
            IFolder iFolder = (IFolder)container;
            iFolder.create(true, true, null);
        }
    }
}

