/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.ddlgen;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.ddlgen.wizards.EclipseLinkGenerateDDLWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkDDLGeneratorUi {
    private final JpaProject project;
    private static final String CR = StringTools.CR;

    public static void generate(JpaProject project) {
        new EclipseLinkDDLGeneratorUi(project).generate();
    }

    protected EclipseLinkDDLGeneratorUi(JpaProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    protected void generate() {
        PersistenceUnit persistenceUnit = (PersistenceUnit)this.getPersistenceUnits().iterator().next();
        String puName = persistenceUnit.getName();
        EclipseLinkGenerateDDLWizard wizard = this.buildGenerateDDLWizard(this.project, puName);
        WizardDialog wizardDialog = new WizardDialog(this.getCurrentShell(), (IWizard)wizard);
        wizardDialog.create();
        if (wizard.getPageCount() > 0) {
            wizardDialog.open();
        }
    }

    protected EclipseLinkGenerateDDLWizard buildGenerateDDLWizard(JpaProject project, String puName) {
        return new EclipseLinkGenerateDDLWizard(project, puName);
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }

    protected JpaPlatform getPlatform() {
        return this.project.getJpaPlatform();
    }

    protected ListIterable<PersistenceUnit> getPersistenceUnits() {
        return this.getPersistence().getPersistenceUnits();
    }

    protected Persistence getPersistence() {
        return this.project.getContextModelRoot().getPersistenceXml().getRoot();
    }
}

