/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ComboTools;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXmlEnumValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogging;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOptions;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkTargetDatabase;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkTargetServer;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options.EclipseLinkLoggingComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options.EclipseLinkPersistenceXmlSchemaGenerationComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkPersistenceUnitOptionsEditorPage
extends Pane<PersistenceUnit> {
    private PropertyValueModel<EclipseLinkOptions> optionsHolder;

    public EclipseLinkPersistenceUnitOptionsEditorPage(PropertyValueModel<PersistenceUnit> persistenceUnitModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(persistenceUnitModel, parentComposite, widgetFactory, resourceManager);
    }

    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.buildOptionsSection(container);
        this.buildSchemaGenerationSection(container);
        this.buildLoggingSection(container);
        this.buildMiscellaneousSection(container);
    }

    protected Section buildLoggingSection(Composite container) {
        Section loggingSection = this.getWidgetFactory().createSection(container, 256);
        loggingSection.setText(JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_SECTION_TITLE);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        loggingSection.setLayoutData((Object)gridData);
        Control loggingComposite = this.initializeLoggingSection(loggingSection);
        loggingSection.setClient(loggingComposite);
        return loggingSection;
    }

    protected Control initializeLoggingSection(Section section) {
        return new EclipseLinkLoggingComposite<EclipseLinkLogging>(this, this.buildLoggingHolder(), (Composite)section).getControl();
    }

    private PropertyValueModel<EclipseLinkLogging> buildLoggingHolder() {
        return new TransformationPropertyValueModel<PersistenceUnit, EclipseLinkLogging>(this.getSubjectHolder()){

            protected EclipseLinkLogging transform_(PersistenceUnit value) {
                return ((EclipseLinkPersistenceUnit)value).getLogging();
            }
        };
    }

    protected Section buildSchemaGenerationSection(Composite container) {
        Section schemaGenerationSection = this.getWidgetFactory().createSection(container, 256);
        schemaGenerationSection.setText(JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_ECLIPSELINK_SCHEMA_GENERATION_TAB_SECTION_TITLE);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        schemaGenerationSection.setLayoutData((Object)gridData);
        Control schemaGenerationComposite = this.initializeSchemaGenerationSection(schemaGenerationSection);
        schemaGenerationSection.setClient(schemaGenerationComposite);
        return schemaGenerationSection;
    }

    protected Control initializeSchemaGenerationSection(Section section) {
        return new EclipseLinkPersistenceXmlSchemaGenerationComposite(this, this.buildSchemaGenerationHolder(), (Composite)section).getControl();
    }

    private PropertyValueModel<EclipseLinkSchemaGeneration> buildSchemaGenerationHolder() {
        return new TransformationPropertyValueModel<PersistenceUnit, EclipseLinkSchemaGeneration>(this.getSubjectHolder()){

            protected EclipseLinkSchemaGeneration transform_(PersistenceUnit value) {
                return ((EclipseLinkPersistenceUnit)value).getEclipseLinkSchemaGeneration();
            }
        };
    }

    protected Section buildMiscellaneousSection(Composite container) {
        Section miscellaneousSection = this.getWidgetFactory().createSection(container, 256);
        miscellaneousSection.setText(JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_MISCELLANEOUS_SECTION_TITLE);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        miscellaneousSection.setLayoutData((Object)gridData);
        Control miscellaneousComposite = this.initializeMiscellaneousSection(miscellaneousSection);
        miscellaneousSection.setClient(miscellaneousComposite);
        return miscellaneousSection;
    }

    protected Control initializeMiscellaneousSection(Section section) {
        Composite container = this.addSubPane((Composite)section);
        this.addTriStateCheckBoxWithDefault(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_TEMPORAL_MUTABLE_LABEL, this.buildTemporalMutableHolder(), this.buildTemporalMutableStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS);
        return container;
    }

    protected Section buildOptionsSection(Composite container) {
        Section sessionOptionsSection = this.getWidgetFactory().createSection(container, 256);
        sessionOptionsSection.setText(JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_SESSION_SECTION_TITLE);
        Control sessionOptionsComposite = this.initializeSessionOptionsSection(sessionOptionsSection);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        sessionOptionsSection.setLayoutData((Object)gridData);
        sessionOptionsSection.setClient(sessionOptionsComposite);
        return sessionOptionsSection;
    }

    private Control initializeSessionOptionsSection(Section section) {
        this.optionsHolder = this.buildOptionsHolder();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        Composite container = this.addPane((Composite)section, (Layout)layout);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_SESSION_NAME);
        Combo sessionNameCombo = this.addEditableCombo(container, this.buildDefaultSessionNameListHolder(), this.buildSessionNameHolder(), TransformerTools.objectToStringTransformer(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_SESSION_NAME);
        ComboTools.handleDefaultValue((Combo)sessionNameCombo);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_SESSIONS_XML);
        Combo sessionsXmlCombo = this.addEditableCombo(container, this.buildDefaultSessionsXmlFileNameListHolder(), this.buildSessionsXmlFileNameHolder(), TransformerTools.objectToStringTransformer(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_SESSIONS_XML);
        ComboTools.handleDefaultValue((Combo)sessionsXmlCombo);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_TARGET_DATABASE_LABEL);
        Combo targetDatabaseCombo = this.addEditableCombo(container, this.buildTargetDatabaseListHolder(), this.buildTargetDatabaseHolder(), this.buildTargetDatabaseLabelTransformer(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_TARGET_DATABASE);
        ComboTools.handleDefaultValue((Combo)targetDatabaseCombo);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_TARGET_SERVER_LABEL);
        Combo targetServerCombo = this.addEditableCombo(container, this.buildTargetServerListHolder(), this.buildTargetServerHolder(), this.buildTargetServerConverter(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_TARGET_SERVER);
        ComboTools.handleDefaultValue((Combo)targetServerCombo);
        Hyperlink eventListenerLink = this.addHyperlink(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_EVENT_LISTENER_LABEL);
        this.initializeEventListenerClassChooser(container, eventListenerLink);
        TriStateCheckBox includeDescriptorQueriesCheckBox = this.addTriStateCheckBoxWithDefault(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_INCLUDE_DESCRIPTOR_QUERIES_LABEL, this.buildIncludeDescriptorQueriesHolder(), this.buildIncludeDescriptorQueriesStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        includeDescriptorQueriesCheckBox.getCheckBox().setLayoutData((Object)gridData);
        return container;
    }

    private PropertyValueModel<EclipseLinkOptions> buildOptionsHolder() {
        return new TransformationPropertyValueModel<PersistenceUnit, EclipseLinkOptions>(this.getSubjectHolder()){

            protected EclipseLinkOptions transform_(PersistenceUnit value) {
                return ((EclipseLinkPersistenceUnit)value).getEclipseLinkOptions();
            }
        };
    }

    private PropertyValueModel<String> buildDefaultSessionNameHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{""}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionNameDefaultValue((EclipseLinkOptions)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultSessionNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSessionNameHolder());
    }

    private ModifiablePropertyValueModel<String> buildSessionNameHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{"sessionName"}){

            protected String buildValue_() {
                String name = ((EclipseLinkOptions)this.subject).getSessionName();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionNameDefaultValue((EclipseLinkOptions)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionNameDefaultValue((EclipseLinkOptions)this.subject).equals(value)) {
                    value = null;
                }
                ((EclipseLinkOptions)this.subject).setSessionName(value);
            }
        };
    }

    private String getSessionNameDefaultValue(EclipseLinkOptions subject) {
        String defaultValue = subject.getDefaultSessionName();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private PropertyValueModel<String> buildDefaultSessionsXmlFileNameHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{""}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionsXmlDefaultValue((EclipseLinkOptions)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultSessionsXmlFileNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSessionsXmlFileNameHolder());
    }

    private ModifiablePropertyValueModel<String> buildSessionsXmlFileNameHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{"sessionsXml"}){

            protected String buildValue_() {
                String name = ((EclipseLinkOptions)this.subject).getSessionsXml();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionsXmlDefaultValue((EclipseLinkOptions)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionsXmlDefaultValue((EclipseLinkOptions)this.subject).equals(value)) {
                    value = null;
                }
                ((EclipseLinkOptions)this.subject).setSessionsXml(value);
            }
        };
    }

    private String getSessionsXmlDefaultValue(EclipseLinkOptions subject) {
        String defaultValue = subject.getDefaultSessionsXml();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private PropertyValueModel<String> buildDefaultTargetDatabaseHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{EclipseLinkOptions.DEFAULT_TARGET_DATABASE}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetDatabaseDefaultValue((EclipseLinkOptions)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultTargetDatabaseListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultTargetDatabaseHolder());
    }

    String buildTargetDatabaseDisplayString(String targetDatabaseName) {
        switch (EclipseLinkTargetDatabase.valueOf((String)targetDatabaseName)) {
            case attunity: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_ATTUNITY;
            }
            case auto: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_AUTO;
            }
            case cloudscape: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_CLOUDSCAPE;
            }
            case database: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_DATABASE;
            }
            case db2: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_DB2;
            }
            case db2mainframe: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_DB2_MAINFRAME;
            }
            case dbase: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_DBASE;
            }
            case derby: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_DERBY;
            }
            case hsql: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_HSQL;
            }
            case informix: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_INFORMIX;
            }
            case informix11: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_INFORMIX11;
            }
            case javadb: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_JAVADB;
            }
            case maxdb: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_MAXDB;
            }
            case mysql: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_MYSQL;
            }
            case oracle: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_ORACLE;
            }
            case oracle10: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_ORACLE10;
            }
            case oracle11: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_ORACLE11;
            }
            case oracle8: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_ORACLE8;
            }
            case oracle9: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_ORACLE9;
            }
            case pointbase: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_POINTBASE;
            }
            case postgresql: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_POSTGRESQL;
            }
            case sqlanywhere: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_SQLANYWHERE;
            }
            case sqlserver: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_SQLSERVER;
            }
            case sybase: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_SYBASE;
            }
            case symfoware: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_SYMFOWARE;
            }
            case timesten: {
                return JptJpaEclipseLinkUiMessages.TARGET_DATABASE_COMPOSITE_TIMESTEN;
            }
        }
        throw new IllegalStateException();
    }

    private Comparator<String> buildTargetDatabaseComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String targetDatabase1, String targetDatabase2) {
                targetDatabase1 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetDatabaseDisplayString(targetDatabase1);
                targetDatabase2 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetDatabaseDisplayString(targetDatabase2);
                return Collator.getInstance().compare(targetDatabase1, targetDatabase2);
            }
        };
    }

    private Transformer<String, String> buildTargetDatabaseLabelTransformer() {
        return new TargetDatabaseLabelTransformer();
    }

    private ModifiablePropertyValueModel<String> buildTargetDatabaseHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{"targetDatabase"}){

            protected String buildValue_() {
                String name = ((EclipseLinkOptions)this.subject).getTargetDatabase();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetDatabaseDefaultValue((EclipseLinkOptions)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetDatabaseDefaultValue((EclipseLinkOptions)this.subject).equals(value)) {
                    value = null;
                }
                ((EclipseLinkOptions)this.subject).setTargetDatabase(value);
            }
        };
    }

    private ListValueModel<String> buildTargetDatabaseListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultTargetDatabaseListHolder());
        holders.add(this.buildTargetDatabasesListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Iterator<String> buildTargetDatabases() {
        return IteratorTools.transform((Iterator)IteratorTools.iterator((Object[])EclipseLinkTargetDatabase.values()), (Transformer)PersistenceXmlEnumValue.ENUM_NAME_TRANSFORMER);
    }

    private CollectionValueModel<String> buildTargetDatabasesCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildTargetDatabases()));
    }

    private ListValueModel<String> buildTargetDatabasesListHolder() {
        return new SortedListValueModelAdapter(this.buildTargetDatabasesCollectionHolder(), this.buildTargetDatabaseComparator());
    }

    private String getTargetDatabaseDefaultValue(EclipseLinkOptions subject) {
        String defaultValue = subject.getDefaultTargetDatabase();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private PropertyValueModel<String> buildDefaultTargetServerHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{EclipseLinkOptions.DEFAULT_TARGET_SERVER}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetServerDefaultValue((EclipseLinkOptions)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultTargetServerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultTargetServerHolder());
    }

    String buildTargetServerDisplayString(String targetServerName) {
        switch (EclipseLinkTargetServer.valueOf((String)targetServerName)) {
            case jboss: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_JBOSS;
            }
            case netweaver_7_1: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_NETWEAVER_7_1;
            }
            case none: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_NONE;
            }
            case oc4j: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_OC4J;
            }
            case sunas9: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_SUNAS9;
            }
            case weblogic: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_WEBLOGIC;
            }
            case weblogic_10: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_WEBLOGIC_10;
            }
            case weblogic_9: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_WEBLOGIC_9;
            }
            case websphere: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_WEBSPHERE;
            }
            case websphere_6_1: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_WEBSPHERE_6_1;
            }
            case websphere_7: {
                return JptJpaEclipseLinkUiMessages.TARGET_SERVER_COMPOSITE_WEBSPHERE_7;
            }
        }
        throw new IllegalStateException();
    }

    private Comparator<String> buildTargetServerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String targetServer1, String targetServer2) {
                targetServer1 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetServerDisplayString(targetServer1);
                targetServer2 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetServerDisplayString(targetServer2);
                return Collator.getInstance().compare(targetServer1, targetServer2);
            }
        };
    }

    private Transformer<String, String> buildTargetServerConverter() {
        return new TargetServerLabelTransformer();
    }

    private ModifiablePropertyValueModel<String> buildTargetServerHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.optionsHolder, new String[]{"targetServer"}){

            protected String buildValue_() {
                String name = ((EclipseLinkOptions)this.subject).getTargetServer();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetServerDefaultValue((EclipseLinkOptions)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetServerDefaultValue((EclipseLinkOptions)this.subject).equals(value)) {
                    value = null;
                }
                ((EclipseLinkOptions)this.subject).setTargetServer(value);
            }
        };
    }

    private ListValueModel<String> buildTargetServerListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultTargetServerListHolder());
        holders.add(this.buildTargetServersListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Iterator<String> buildTargetServers() {
        return IteratorTools.transform((Iterator)IteratorTools.iterator((Object[])EclipseLinkTargetServer.values()), (Transformer)PersistenceXmlEnumValue.ENUM_NAME_TRANSFORMER);
    }

    private CollectionValueModel<String> buildTargetServersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildTargetServers()));
    }

    private ListValueModel<String> buildTargetServersListHolder() {
        return new SortedListValueModelAdapter(this.buildTargetServersCollectionHolder(), this.buildTargetServerComparator());
    }

    private String getTargetServerDefaultValue(EclipseLinkOptions subject) {
        String defaultValue = subject.getDefaultTargetServer();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private ClassChooserPane<EclipseLinkOptions> initializeEventListenerClassChooser(Composite container, Hyperlink hyperlink) {
        return new ClassChooserPane<EclipseLinkOptions>((Pane)this, this.optionsHolder, container, hyperlink){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EclipseLinkOptions, String>(this.getSubjectHolder(), new String[]{"eventListener"}){

                    protected String buildValue_() {
                        return ((EclipseLinkOptions)this.subject).getEventListener();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((EclipseLinkOptions)this.subject).setEventListener(value);
                    }
                };
            }

            protected String getClassName() {
                return ((EclipseLinkOptions)this.getSubject()).getEventListener();
            }

            protected IJavaProject getJavaProject() {
                return ((EclipseLinkOptions)this.getSubject()).getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                ((EclipseLinkOptions)this.getSubject()).setEventListener(className);
            }

            protected String getSuperInterfaceName() {
                return "org.eclipse.persistence.sessions.SessionEventListener";
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildIncludeDescriptorQueriesHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, Boolean>(this.optionsHolder, new String[]{"includeDescriptorQueriesy"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkOptions)this.subject).getIncludeDescriptorQueries();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkOptions)this.subject).setIncludeDescriptorQueries(value);
            }
        };
    }

    private PropertyValueModel<String> buildIncludeDescriptorQueriesStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultIncludeDescriptorQueriesHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_INCLUDE_DESCRIPTOR_QUERIES_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_INCLUDE_DESCRIPTOR_QUERIES_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultIncludeDescriptorQueriesHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, Boolean>(this.optionsHolder, new String[]{"includeDescriptorQueriesy"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkOptions)this.subject).getIncludeDescriptorQueries() != null) {
                    return null;
                }
                return ((EclipseLinkOptions)this.subject).getDefaultIncludeDescriptorQueries();
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> buildTemporalMutableHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, Boolean>(this.optionsHolder, new String[]{"temporalMutable"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkOptions)this.subject).getTemporalMutable();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkOptions)this.subject).setTemporalMutable(value);
            }
        };
    }

    protected PropertyValueModel<String> buildTemporalMutableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultTemporalMutableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_TEMPORAL_MUTABLE_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_OPTIONS_TAB_TEMPORAL_MUTABLE_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultTemporalMutableHolder() {
        return new PropertyAspectAdapter<EclipseLinkOptions, Boolean>(this.optionsHolder, new String[]{"temporalMutable"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkOptions)this.subject).getTemporalMutable() != null) {
                    return null;
                }
                return ((EclipseLinkOptions)this.subject).getDefaultTemporalMutable();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TargetDatabaseLabelTransformer
    extends TransformerAdapter<String, String> {
        TargetDatabaseLabelTransformer() {
        }

        public String transform(String value) {
            try {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetDatabaseDisplayString(value);
            }
            catch (RuntimeException runtimeException) {
                return value;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TargetServerLabelTransformer
    extends TransformerAdapter<String, String> {
        TargetServerLabelTransformer() {
        }

        public String transform(String value) {
            try {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetServerDisplayString(value);
            }
            catch (RuntimeException runtimeException) {
                return value;
            }
        }
    }
}

