/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.LiferayServerCore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtil {
    private static void addRemoveProps(IPath deltaPath, IResource deltaResource, ZipOutputStream zip, Map<ZipEntry, String> deleteEntries, String deletePrefix) throws IOException {
        String archive = ServerUtil.removeArchive(deltaPath.toPortableString());
        ZipEntry zipEntry = null;
        for (ZipEntry entry : deleteEntries.keySet()) {
            if (!entry.getName().startsWith(archive)) continue;
            zipEntry = entry;
        }
        if (zipEntry == null) {
            zipEntry = new ZipEntry(String.valueOf(archive) + "META-INF/" + deletePrefix + "-partialapp-delete.props");
        }
        String existingFiles = deleteEntries.get(zipEntry);
        String file = deltaPath.toPortableString().substring(archive.length());
        if (deltaResource.getType() == 2) {
            file = String.valueOf(file) + "/.*";
        }
        deleteEntries.put(zipEntry, String.valueOf(existingFiles != null ? existingFiles : "") + file + "\n");
    }

    private static void addToZip(IPath path, IResource resource, ZipOutputStream zip, boolean adjustGMTOffset) throws IOException, CoreException {
        switch (resource.getType()) {
            case 1: {
                ZipEntry zipEntry = new ZipEntry(path.toString());
                zip.putNextEntry(zipEntry);
                InputStream contents = ((IFile)resource).getContents();
                if (adjustGMTOffset) {
                    TimeZone currentTimeZone = TimeZone.getDefault();
                    GregorianCalendar currentDt = new GregorianCalendar(currentTimeZone, Locale.getDefault());
                    int gmtOffset = currentTimeZone.getOffset(currentDt.get(0), currentDt.get(1), currentDt.get(2), currentDt.get(5), currentDt.get(7), currentDt.get(14));
                    zipEntry.setTime(System.currentTimeMillis() + (long)(gmtOffset * -1));
                }
                try {
                    IOUtils.copy((InputStream)contents, (OutputStream)zip);
                    break;
                }
                finally {
                    contents.close();
                }
            }
            case 2: 
            case 4: {
                IResource[] members;
                IContainer container = (IContainer)resource;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    ServerUtil.addToZip(path.append(res.getName()), res, zip, adjustGMTOffset);
                    ++n2;
                }
                break;
            }
        }
    }

    public static Map<String, String> configureAppServerProperties(ILiferayRuntime liferayRuntime) {
        return ServerUtil.getSDKRequiredProperties(liferayRuntime);
    }

    public static Map<String, String> configureAppServerProperties(IProject project) throws CoreException {
        try {
            return ServerUtil.getSDKRequiredProperties(ServerUtil.getLiferayRuntime(project));
        }
        catch (CoreException e1) {
            throw new CoreException(LiferayServerCore.createErrorStatus((Exception)((Object)e1)));
        }
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, "com.liferay.ide.server.core", msg);
    }

    public static File createPartialEAR(String archiveName, IModuleResourceDelta[] deltas, String deletePrefix, String deltaPrefix, boolean adjustGMTOffset) {
        File file;
        block15: {
            IPath path = LiferayServerCore.getTempLocation("partial-ear", archiveName);
            FileOutputStream outputStream = null;
            ZipOutputStream zip = null;
            file = path.toFile();
            file.getParentFile().mkdirs();
            try {
                try {
                    outputStream = new FileOutputStream(file);
                    zip = new ZipOutputStream(outputStream);
                    HashMap<ZipEntry, String> deleteEntries = new HashMap<ZipEntry, String>();
                    ServerUtil.processResourceDeltasZip(deltas, zip, deleteEntries, deletePrefix, deltaPrefix, adjustGMTOffset);
                    for (ZipEntry entry : deleteEntries.keySet()) {
                        zip.putNextEntry(entry);
                        zip.write(((String)deleteEntries.get(entry)).getBytes());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    public static File createPartialWAR(String archiveName, IModuleResourceDelta[] deltas, String deletePrefix, boolean adjustGMTOffset) {
        File file;
        block15: {
            IPath path = LiferayServerCore.getTempLocation("partial-war", archiveName);
            FileOutputStream outputStream = null;
            ZipOutputStream zip = null;
            file = path.toFile();
            file.getParentFile().mkdirs();
            try {
                try {
                    outputStream = new FileOutputStream(file);
                    zip = new ZipOutputStream(outputStream);
                    HashMap<ZipEntry, String> deleteEntries = new HashMap<ZipEntry, String>();
                    ServerUtil.processResourceDeltasZip(deltas, zip, deleteEntries, deletePrefix, "", adjustGMTOffset);
                    for (ZipEntry entry : deleteEntries.keySet()) {
                        zip.putNextEntry(entry);
                        zip.write(((String)deleteEntries.get(entry)).getBytes());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    public static IServerWorkingCopy createServerForRuntime(IRuntime runtime) {
        IServerType[] iServerTypeArray = ServerCore.getServerTypes();
        int n = iServerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServerType serverType = iServerTypeArray[n2];
            if (serverType.getRuntimeType().equals(runtime.getRuntimeType())) {
                try {
                    return serverType.createServer("server", null, runtime, null);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return null;
    }

    public static Properties getAllCategories(IPath portalDir) {
        Properties retval = null;
        File implJar = portalDir.append("WEB-INF/lib/portal-impl.jar").toFile();
        if (implJar.exists()) {
            try {
                JarFile jar = new JarFile(implJar);
                Properties categories = new Properties();
                Properties props = new Properties();
                props.load(jar.getInputStream(jar.getEntry("content/Language.properties")));
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    if (!name.startsWith("category.")) continue;
                    categories.put(name, props.getProperty(name));
                }
                retval = categories;
            }
            catch (IOException e) {
                LiferayServerCore.logError(e);
            }
        }
        return retval;
    }

    public static IPath getAppServerDir(org.eclipse.wst.common.project.facet.core.runtime.IRuntime serverRuntime) {
        ILiferayRuntime runtime = (ILiferayRuntime)ServerUtil.getRuntimeAdapter(serverRuntime, ILiferayRuntime.class);
        return runtime != null ? runtime.getAppServerDir() : null;
    }

    public static String getAppServerPropertyKey(String propertyAppServerDeployDir, ILiferayRuntime runtime) {
        String retval;
        block9: {
            retval = null;
            try {
                try {
                    Version version = new Version(runtime.getPortalVersion());
                    String type = runtime.getAppServerType();
                    if (CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V6130) >= 0 || CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V612) >= 0 && CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V6110) < 0) {
                        retval = MessageFormat.format(propertyAppServerDeployDir, "." + type + ".");
                    }
                }
                catch (Exception exception) {
                    if (retval == null) {
                        retval = MessageFormat.format(propertyAppServerDeployDir, ".");
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (retval == null) {
                    retval = MessageFormat.format(propertyAppServerDeployDir, ".");
                }
                throw throwable;
            }
            if (retval == null) {
                retval = MessageFormat.format(propertyAppServerDeployDir, ".");
            }
        }
        return retval;
    }

    public static Properties getEntryCategories(IPath portalDir, String portalVersion) {
        Properties categories = ServerUtil.getAllCategories(portalDir);
        Properties retval = new Properties();
        String categoryMy = categories.getProperty("category.my");
        if (portalVersion == null || CoreUtil.compareVersions((Version)new Version(portalVersion), (Version)ILiferayConstants.V620) < 0) {
            retval.put("category.my", String.valueOf(categoryMy) + " Account Section");
            retval.put("category.portal", String.valueOf(categories.getProperty("category.portal")) + " Section");
            retval.put("category.server", String.valueOf(categories.getProperty("category.server")) + " Section");
            retval.put("category.content", String.valueOf(categories.getProperty("category.content")) + " Section");
        } else {
            retval.put("category.my", String.valueOf(categoryMy) + " Account Administration");
            retval.put("category.users", "Control Panel - " + categories.getProperty("category.users"));
            retval.put("category.apps", "Control Panel - " + categories.getProperty("category.apps"));
            retval.put("category.configuration", "Control Panel - " + categories.getProperty("category.configuration"));
            retval.put("category.sites", "Control Panel - " + categories.getProperty("category.sites"));
            retval.put("category.site_administration.configuration", "Site Administration - " + categories.getProperty("category.site_administration.configuration"));
            retval.put("category.site_administration.content", "Site Administration - " + categories.getProperty("category.site_administration.content"));
            retval.put("category.site_administration.pages", "Site Administration - " + categories.getProperty("category.site_administration.pages"));
            retval.put("category.site_administration.users", "Site Administration - " + categories.getProperty("category.site_administration.users"));
        }
        return retval;
    }

    public static IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IProjectFacet getLiferayFacet(IFacetedProject facetedProject) {
        for (IProjectFacetVersion projectFacet : facetedProject.getProjectFacets()) {
            if (!ServerUtil.isLiferayFacet(projectFacet.getProjectFacet())) continue;
            return projectFacet.getProjectFacet();
        }
        return null;
    }

    public static ILiferayRuntime getLiferayRuntime(BridgedRuntime bridgedRuntime) {
        IRuntime runtime;
        String id;
        if (bridgedRuntime != null && (id = bridgedRuntime.getProperty("id")) != null && ServerUtil.isLiferayRuntime(runtime = ServerCore.findRuntime((String)id))) {
            return ServerUtil.getLiferayRuntime(runtime);
        }
        return null;
    }

    public static ILiferayRuntime getLiferayRuntime(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject != null) {
            return (ILiferayRuntime)ServerUtil.getRuntimeAdapter(facetedProject.getPrimaryRuntime(), ILiferayRuntime.class);
        }
        return null;
    }

    public static Set<IRuntime> getAvailableLiferayRuntimes() {
        IRuntime[] runtimes;
        HashSet<IRuntime> retval = new HashSet<IRuntime>();
        IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            if (ServerUtil.isLiferayRuntime(rt)) {
                retval.add(rt);
            }
            ++n2;
        }
        return retval;
    }

    public static ILiferayRuntime getLiferayRuntime(String name) {
        return ServerUtil.getLiferayRuntime(ServerUtil.getRuntime(name));
    }

    public static ILiferayRuntime getLiferayRuntime(IRuntime runtime) {
        if (runtime != null) {
            return (ILiferayRuntime)runtime.createWorkingCopy().loadAdapter(ILiferayRuntime.class, null);
        }
        return null;
    }

    public static ILiferayRuntime getLiferayRuntime(IServer server) {
        if (server != null) {
            return ServerUtil.getLiferayRuntime(server.getRuntime());
        }
        return null;
    }

    public static IPath getPortalDir(IJavaProject project) {
        return ServerUtil.getPortalDir(project.getProject());
    }

    public static IPath getPortalDir(IProject project) {
        IPath retval = null;
        ILiferayProject liferayProject = LiferayCore.create((Object)project);
        if (liferayProject != null) {
            retval = liferayProject.getAppServerPortalDir();
        }
        return retval;
    }

    public static Properties getPortletCategories(IPath portalDir) {
        Properties props = ServerUtil.getAllCategories(portalDir);
        Properties categories = new Properties();
        Enumeration<?> names = props.propertyNames();
        String[] controlPanelCategories = new String[]{"category.my", "category.users", "category.apps", "category.configuration", "category.sites", "category.site_administration.configuration", "category.site_administration.content", "category.site_administration.pages", "category.site_administration.users"};
        while (names.hasMoreElements()) {
            boolean isControlPanelCategory = false;
            String name = names.nextElement().toString();
            String[] stringArray = controlPanelCategories;
            int n = controlPanelCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                if (name.equals(category)) {
                    isControlPanelCategory = true;
                    break;
                }
                ++n2;
            }
            if (isControlPanelCategory) continue;
            categories.put(name, props.getProperty(name));
        }
        return categories;
    }

    public static IRuntime getRuntime(IProject project) throws CoreException {
        return (IRuntime)ServerUtil.getRuntimeAdapter(ProjectFacetsManager.create((IProject)project).getPrimaryRuntime(), IRuntime.class);
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        return ServerCore.findRuntime((String)runtime.getProperty("id"));
    }

    public static IRuntime getRuntime(String runtimeName) {
        IRuntime[] runtimes;
        IRuntime retval = null;
        if (!CoreUtil.isNullOrEmpty((String)runtimeName) && (runtimes = ServerCore.getRuntimes()) != null) {
            IRuntime[] iRuntimeArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                if (runtimeName.equals(runtime.getName())) {
                    retval = runtime;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public static IRuntimeWorkingCopy getRuntime(String runtimeTypeId, IPath location) {
        IRuntimeType runtimeType = ServerCore.findRuntimeType((String)runtimeTypeId);
        try {
            IRuntimeWorkingCopy runtime = runtimeType.createRuntime("runtime", null);
            IRuntimeWorkingCopy runtimeWC = runtime.createWorkingCopy();
            runtimeWC.setName("Runtime");
            runtimeWC.setLocation(location);
            return runtimeWC;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getRuntimeAdapter(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime, Class<?> adapterClass) {
        if (facetRuntime != null) {
            String runtimeId = facetRuntime.getProperty("id");
            IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
            int n = iRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                if (runtime.getId().equals(runtimeId)) {
                    if (IRuntime.class.equals(adapterClass)) {
                        return runtime;
                    }
                    IRuntimeWorkingCopy runtimeWC = null;
                    runtimeWC = !runtime.isWorkingCopy() ? runtime.createWorkingCopy() : (IRuntimeWorkingCopy)runtime;
                    return (ILiferayRuntime)runtimeWC.loadAdapter(adapterClass, null);
                }
                ++n2;
            }
        }
        return null;
    }

    public static Map<String, String> getSDKRequiredProperties(ILiferayRuntime appServer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String type = appServer.getAppServerType();
        String dir = appServer.getAppServerDir().toOSString();
        String deployDir = appServer.getAppServerDeployDir().toOSString();
        String libGlobalDir = appServer.getAppServerLibGlobalDir().toOSString();
        String parentDir = new File(dir).getParent();
        String portalDir = appServer.getAppServerPortalDir().toOSString();
        properties.put("app.server.type", type);
        String appServerDirKey = ServerUtil.getAppServerPropertyKey("app.server{0}dir", appServer);
        String appServerDeployDirKey = ServerUtil.getAppServerPropertyKey("app.server{0}deploy.dir", appServer);
        String appServerLibGlobalDirKey = ServerUtil.getAppServerPropertyKey("app.server{0}lib.global.dir", appServer);
        String appServerPortalDirKey = ServerUtil.getAppServerPropertyKey("app.server{0}portal.dir", appServer);
        properties.put(appServerDirKey, dir);
        properties.put(appServerDeployDirKey, deployDir);
        properties.put(appServerLibGlobalDirKey, libGlobalDir);
        properties.put("app.server.parent.dir", parentDir);
        properties.put(appServerPortalDirKey, portalDir);
        return properties;
    }

    public static IServer[] getServersForRuntime(IRuntime runtime) {
        Object[] servers;
        ArrayList<Object> serverList = new ArrayList<Object>();
        if (runtime != null && !CoreUtil.isNullOrEmpty((Object[])(servers = ServerCore.getServers()))) {
            Object[] objectArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                Object server = objectArray[n2];
                if (runtime.equals(server.getRuntime())) {
                    serverList.add(server);
                }
                ++n2;
            }
        }
        return serverList.toArray(new IServer[0]);
    }

    public static String[] getServletFilterNames(IPath portalDir) throws Exception {
        ArrayList<String> retval = new ArrayList<String>();
        File filtersWebXmlFile = portalDir.append("WEB-INF/liferay-web.xml").toFile();
        if (!filtersWebXmlFile.exists()) {
            filtersWebXmlFile = portalDir.append("WEB-INF/web.xml").toFile();
        }
        if (filtersWebXmlFile.exists()) {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(filtersWebXmlFile);
            NodeList filterNameElements = document.getElementsByTagName("filter-name");
            int i = 0;
            while (i < filterNameElements.getLength()) {
                Node filterNameElement = filterNameElements.item(i);
                String content = filterNameElement.getTextContent();
                if (!CoreUtil.isNullOrEmpty((String)content)) {
                    retval.add(content.trim());
                }
                ++i;
            }
        }
        return retval.toArray(new String[0]);
    }

    public static boolean hasFacet(IProject project, IProjectFacet checkProjectFacet) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null || checkProjectFacet == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null || checkProjectFacet == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!checkProjectFacet.equals(projectFacet)) continue;
                    retval = true;
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public static boolean isExistingVMName(String name) {
        IVMInstall[] iVMInstallArray = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType").getVMInstalls();
        int n = iVMInstallArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall vm = iVMInstallArray[n2];
            if (vm.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isExtProject(IProject project) {
        return ServerUtil.hasFacet(project, ProjectFacetsManager.getProjectFacet((String)"liferay.ext"));
    }

    public static boolean isLiferayFacet(IProjectFacet projectFacet) {
        return projectFacet != null && projectFacet.getId().startsWith("liferay");
    }

    public static boolean isLiferayRuntime(BridgedRuntime bridgedRuntime) {
        String id;
        if (bridgedRuntime != null && (id = bridgedRuntime.getProperty("id")) != null) {
            IRuntime runtime = ServerCore.findRuntime((String)id);
            return ServerUtil.isLiferayRuntime(runtime);
        }
        return false;
    }

    public static boolean isLiferayRuntime(IRuntime runtime) {
        return ServerUtil.getLiferayRuntime(runtime) != null;
    }

    public static boolean isLiferayRuntime(IServer server) {
        return ServerUtil.getLiferayRuntime(server) != null;
    }

    public static boolean isValidPropertiesFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            new PropertiesConfiguration(file);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void processResourceDeltasZip(IModuleResourceDelta[] deltas, ZipOutputStream zip, Map<ZipEntry, String> deleteEntries, String deletePrefix, String deltaPrefix, boolean adjustGMTOffset) throws IOException, CoreException {
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            int deltaKind = delta.getKind();
            IResource deltaResource = (IResource)delta.getModuleResource().getAdapter(IResource.class);
            IProject deltaProject = deltaResource.getProject();
            IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)deltaProject);
            Path deltaPath = null;
            if (webappRoot != null) {
                IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
                int n3 = iContainerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IContainer container = iContainerArray[n4];
                    if (container != null && container.exists()) {
                        IPath deltaFullPath = deltaResource.getFullPath();
                        IPath containerFullPath = container.getFullPath();
                        deltaPath = new Path(String.valueOf(deltaPrefix) + deltaFullPath.makeRelativeTo(containerFullPath));
                        if (deltaPath != null && deltaPath.segmentCount() > 0) break;
                    }
                    ++n4;
                }
            }
            if (deltaKind == 1 || deltaKind == 2) {
                ServerUtil.addToZip(deltaPath, deltaResource, zip, adjustGMTOffset);
            } else if (deltaKind == 3) {
                ServerUtil.addRemoveProps(deltaPath, deltaResource, zip, deleteEntries, deletePrefix);
            } else if (deltaKind == 0) {
                IModuleResourceDelta[] children = delta.getAffectedChildren();
                ServerUtil.processResourceDeltasZip(children, zip, deleteEntries, deletePrefix, deltaPrefix, adjustGMTOffset);
            }
            ++n2;
        }
    }

    private static String removeArchive(String archive) {
        int index = Math.max(archive.lastIndexOf(".war"), archive.lastIndexOf(".jar"));
        if (index >= 0) {
            return archive.substring(0, index + 5);
        }
        return "";
    }

    public static void terminateLaunchesForConfig(ILaunchConfigurationWorkingCopy config) throws DebugException {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch.getLaunchConfiguration().equals(config)) {
                launch.terminate();
            }
            ++n2;
        }
    }

    public static org.eclipse.wst.common.project.facet.core.runtime.IRuntime getFacetRuntime(IRuntime runtime) {
        return RuntimeManager.getRuntime((String)runtime.getName());
    }

    public static ILiferayRuntime getLiferayRuntime(IRuntime runtime, IProgressMonitor monitor) {
        return (ILiferayRuntime)runtime.loadAdapter(ILiferayRuntime.class, monitor);
    }
}

