/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.ui;

import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.ui.InstalledSDKsCompostite;
import com.liferay.ide.sdk.ui.SDKUIPlugin;
import com.liferay.ide.ui.util.SWTUtil;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SDKsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.liferay.ide.sdk.preferences.installedSDKs";
    private Composite parent;
    protected InstalledSDKsCompostite installedSDKsComposite;
    private ScopedPreferenceStore prefStore;

    public SDKsPreferencePage() {
        this.setImageDescriptor(SDKUIPlugin.imageDescriptorFromPlugin((String)"com.liferay.ide.sdk.ui", (String)"/icons/e16/sdk.png"));
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.prefStore == null) {
            this.prefStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.liferay.ide.eclipse.sdk");
            String defaultValue = new DefaultScope().getNode("com.liferay.ide.sdk.ui").get("OVERWRITE_USER_BUILD_FILE", "always");
            this.prefStore.setDefault("OVERWRITE_USER_BUILD_FILE", defaultValue);
        }
        return this.prefStore;
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public boolean isValid() {
        return this.installedSDKsComposite != null && (this.installedSDKsComposite.getSDKs().length == 0 || this.installedSDKsComposite.getDefaultSDK() != null);
    }

    public boolean performOk() {
        super.performOk();
        if (this.isValid()) {
            SDK[] sdks = this.installedSDKsComposite.getSDKs();
            if (sdks != null) {
                SDKManager.getInstance().saveSDKs(sdks);
            }
            return true;
        }
        this.setMessage(Msgs.haveOneSDK, 3);
        return false;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.parent = parent;
        SWTUtil.createWrapLabel((Composite)parent, (String)Msgs.addRemoveEditSDKDefinitionsLabel, (int)1, (int)100);
        SWTUtil.createVerticalSpacer((Composite)parent, (int)1, (int)1);
        this.installedSDKsComposite = new InstalledSDKsCompostite(parent, 0);
        this.installedSDKsComposite.setPreferencePage((PreferencePage)this);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        this.installedSDKsComposite.setLayoutData(data);
        this.createFieldEditors();
        this.initialize();
        this.checkState();
        return parent;
    }

    public void applyData(Object data) {
        if ("new".equals(data)) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SDKsPreferencePage.this.installedSDKsComposite.addSDK();
                }
            });
        }
    }

    protected void createFieldEditors() {
        RadioGroupFieldEditor edit = new RadioGroupFieldEditor("OVERWRITE_USER_BUILD_FILE", NLS.bind((String)Msgs.updateProperties, (Object)System.getProperty("user.name")), 3, (String[][])new String[][]{{Msgs.always, "always"}, {Msgs.never, "never"}}, this.parent, true);
        edit.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)edit);
    }

    protected void performDefaults() {
        if (this.installedSDKsComposite != null && !this.installedSDKsComposite.isDisposed()) {
            this.installedSDKsComposite.setSDKs(SDKManager.getInstance().getSDKs());
        }
        this.getPreferenceStore().setValue("prompt", "OVERWRITE_USER_BUILD_FILE");
    }

    private static class Msgs
    extends NLS {
        public static String addRemoveEditSDKDefinitionsLabel;
        public static String always;
        public static String haveOneSDK;
        public static String never;
        public static String updateProperties;

        static {
            Msgs.initializeMessages((String)SDKsPreferencePage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

