/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUIPlugin;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.SWTUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class LiferayProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPluginProjectDataModelProperties {
    private Combo runtimeCombo;

    public LiferayProjectPropertyPage() {
        this.setImageDescriptor(ProjectUIPlugin.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/liferay.png"));
    }

    protected void configureSDKsLinkSelected(SelectionEvent e) {
        String[] id = new String[]{"com.liferay.ide.sdk.preferences.installedSDKs"};
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"com.liferay.ide.sdk.preferences.installedSDKs", (String[])id, null);
        int retval = dialog.open();
        if (retval == 0) {
            this.getContainer().updateButtons();
        }
    }

    protected Control createContents(Composite parent) {
        Composite top = SWTUtil.createTopComposite((Composite)parent, (int)2);
        this.createInfoGroup(top);
        return top;
    }

    protected Group createDefaultGroup(Composite parent, String text, int columns) {
        GridLayout gl = new GridLayout(columns, false);
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)gl);
        return group;
    }

    public boolean performOk() {
        String selectedRuntimeName = this.runtimeCombo.getText();
        if (!CoreUtil.isNullOrEmpty((String)selectedRuntimeName)) {
            final org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = RuntimeManager.getRuntime((String)selectedRuntimeName);
            if (runtime != null) {
                final IFacetedProject fProject = ProjectUtil.getFacetedProject((IProject)this.getProject());
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime = fProject.getPrimaryRuntime();
                if (!runtime.equals(primaryRuntime)) {
                    WorkspaceJob job = new WorkspaceJob("Setting targeted runtime for project."){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            IStatus retval = Status.OK_STATUS;
                            try {
                                fProject.setTargetedRuntimes(Collections.singleton(runtime), monitor);
                                fProject.setPrimaryRuntime(runtime, monitor);
                            }
                            catch (Exception e) {
                                retval = ProjectUIPlugin.createErrorStatus("Could not set targeted runtime", e);
                            }
                            return retval;
                        }
                    };
                    job.schedule();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected void createInfoGroup(Composite parent) {
        new Label(parent, 16384).setText(Msgs.liferayPluginTypeLabel);
        Text pluginTypeLabel = new Text(parent, 2056);
        pluginTypeLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        IProjectFacet liferayFacet = ProjectUtil.getLiferayFacet((IFacetedProject)this.getFacetedProject());
        if (liferayFacet != null) {
            pluginTypeLabel.setText(liferayFacet.getLabel());
        }
        if (SDKUtil.isSDKProject((IProject)this.getProject())) {
            SDK projectSdk = SDKUtil.getSDK((IProject)this.getProject());
            if (projectSdk != null) {
                new Label(parent, 16384).setText(Msgs.liferaySdkLabel);
                Text sdkLabel = new Text(parent, 2056);
                sdkLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
                sdkLabel.setText(projectSdk.getName());
            }
            new Label(parent, 16384).setText(Msgs.liferayRuntimeLabel);
            this.runtimeCombo = new Combo(parent, 12);
            this.runtimeCombo.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            String currentRuntimeName = null;
            try {
                ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IProject)this.getProject());
                currentRuntimeName = liferayRuntime.getRuntime().getName();
            }
            catch (Exception e) {
                ProjectUIPlugin.logError("Could not determine liferay runtime", e);
            }
            ArrayList<String> runtimeNames = new ArrayList<String>();
            int selectionIndex = -1;
            IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
            int n = iRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                if (ServerUtil.isLiferayRuntime((IRuntime)runtime)) {
                    runtimeNames.add(runtime.getName());
                    if (runtime.getName().equals(currentRuntimeName)) {
                        selectionIndex = runtimeNames.size() - 1;
                    }
                }
                ++n2;
            }
            if (runtimeNames.size() == 0) {
                runtimeNames.add("No Liferay runtimes available.");
            }
            this.runtimeCombo.setItems(runtimeNames.toArray(new String[0]));
            if (selectionIndex > -1) {
                this.runtimeCombo.select(selectionIndex);
            }
        }
    }

    protected IFacetedProject getFacetedProject() {
        IFacetedProject retval = null;
        IProject project = this.getProject();
        if (project != null) {
            retval = ProjectUtil.getFacetedProject((IProject)project);
        }
        return retval;
    }

    protected IProject getProject() {
        IAdaptable adaptable = this.getElement();
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        return project;
    }

    private static class Msgs
    extends NLS {
        public static String liferayPluginTypeLabel;
        public static String liferayRuntimeLabel;
        public static String liferaySdkLabel;

        static {
            Msgs.initializeMessages((String)LiferayProjectPropertyPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

