/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.action.NewPluginProjectDropDownAction;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ValidProjectChecker {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALID_PROJECT_TYPES = "validProjectTypes";
    private static final String TAG_NEW_WIZARDS = "newWizards";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_VALUE = "value";
    private static final String TAG_WIZARD = "wizard";
    protected boolean isJsfPortlet = false;
    protected String validProjectTypes = null;
    protected String wizardId = null;
    protected String wizardName = null;

    public ValidProjectChecker(String wizardId) {
        this.wizardId = wizardId;
        this.init();
    }

    public void checkValidProjectTypes() {
        Action defaultAction;
        Shell activeShell;
        Boolean openNewLiferayProjectWizard;
        IProject[] projects = CoreUtil.getAllProjects();
        boolean hasValidProjectTypes = false;
        boolean hasJsfFacet = false;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isLiferayFacetedProject((IProject)project)) {
                Set facets = ProjectUtil.getFacetedProject((IProject)project).getProjectFacets();
                if (this.validProjectTypes != null && facets != null) {
                    String[] validTypes;
                    String[] stringArray = validTypes = this.validProjectTypes.split(",");
                    int n3 = validTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String validProjectType = stringArray[n4];
                        for (IProjectFacetVersion facet : facets) {
                            String id = facet.getProjectFacet().getId();
                            if (this.isJsfPortlet && id.equals("jst.jsf")) {
                                hasJsfFacet = true;
                            }
                            if (!id.startsWith("liferay.") || !id.equals("liferay." + validProjectType)) continue;
                            hasValidProjectTypes = true;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        if (this.isJsfPortlet) {
            boolean bl = hasValidProjectTypes = hasJsfFacet && hasValidProjectTypes;
        }
        if (!hasValidProjectTypes && (openNewLiferayProjectWizard = Boolean.valueOf(MessageDialog.openQuestion((Shell)(activeShell = Display.getDefault().getActiveShell()), (String)NLS.bind((String)Msgs.newElement, (Object)this.wizardName), (String)NLS.bind((String)Msgs.noSuitableLiferayProjects, (Object)this.wizardName)))).booleanValue() && (defaultAction = NewPluginProjectDropDownAction.getDefaultAction()) != null) {
            defaultAction.run();
            this.checkValidProjectTypes();
        }
    }

    private String getValidProjectTypesFromConfig(IConfigurationElement config) {
        IConfigurationElement[] classElements = config.getChildren();
        if (classElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = classElements;
            int n = classElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] paramElements;
                IConfigurationElement classElement = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren(TAG_PARAMETER);
                int n3 = paramElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                    if (ATT_VALID_PROJECT_TYPES.equals(paramElement.getAttribute(ATT_NAME))) {
                        return paramElement.getAttribute(TAG_VALUE);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void init() {
        IExtensionPoint extensionPoint;
        if (this.wizardId != null && this.wizardId.equals("com.liferay.ide.eclipse.portlet.jsf.ui.wizard.portlet")) {
            this.setJsfPortlet(true);
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", TAG_NEW_WIZARDS)) != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_WIZARD) && element.getAttribute(ATT_ID).equals(this.wizardId)) {
                    this.setValidProjectTypes(this.getValidProjectTypesFromConfig(element));
                    this.wizardName = element.getAttribute(ATT_NAME);
                    break;
                }
                ++n2;
            }
        }
    }

    public void setJsfPortlet(boolean isJsfPortlet) {
        this.isJsfPortlet = isJsfPortlet;
    }

    public void setValidProjectTypes(String validProjectTypes) {
        this.validProjectTypes = validProjectTypes;
    }

    private static class Msgs
    extends NLS {
        public static String newElement;
        public static String noSuitableLiferayProjects;

        static {
            Msgs.initializeMessages((String)ValidProjectChecker.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

