/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProject;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.aether.AetherUtil;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.model.ProfileLocation;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.model.Model;
import org.apache.maven.settings.Profile;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayMavenProjectProvider
extends NewLiferayProjectProvider {
    private static final String LIFERAY_ARCHETYPES_GROUP_ID = "com.liferay.maven.archetypes";

    public LiferayMavenProjectProvider() {
        super(new Class[]{IProject.class});
    }

    public IStatus doCreateNewProject(NewLiferayPluginProjectOp op, IProgressMonitor monitor) throws CoreException {
        ProjectImportConfiguration configuration;
        List newProjects;
        Status retval = null;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        IMavenProjectRegistry mavenProjectRegistry = MavenPlugin.getMavenProjectRegistry();
        IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
        String groupId = (String)op.getGroupId().content();
        String artifactId = (String)op.getProjectName().content();
        String version = (String)op.getArtifactVersion().content();
        String javaPackage = (String)op.getGroupId().content();
        String activeProfilesValue = (String)op.getActiveProfilesValue().content();
        PluginType pluginType = (PluginType)op.getPluginType().content(true);
        IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content(true);
        String frameworkName = this.getFrameworkName(op);
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        if (location.lastSegment().equals(artifactId)) {
            location = location.removeLastSegments(1);
        }
        String archetypeType = null;
        archetypeType = pluginType.equals((Object)PluginType.portlet) && portletFramework.isRequiresAdvanced() ? "portlet-" + frameworkName.replace("_", "-") : pluginType.name();
        String archetypeArtifactId = "liferay-" + archetypeType + "-archetype";
        monitor.beginTask("Determining latest Liferay maven plugin archetype version.", -1);
        String archetypeVersion = AetherUtil.getLatestAvailableLiferayArtifact(LIFERAY_ARCHETYPES_GROUP_ID, archetypeArtifactId).getVersion();
        Archetype archetype = new Archetype();
        archetype.setArtifactId(archetypeArtifactId);
        archetype.setGroupId(LIFERAY_ARCHETYPES_GROUP_ID);
        archetype.setModelEncoding("UTF-8");
        archetype.setVersion(archetypeVersion);
        Properties properties = new Properties();
        ResolverConfiguration resolverConfig = new ResolverConfiguration();
        if (!CoreUtil.isNullOrEmpty((String)activeProfilesValue)) {
            resolverConfig.setSelectedProfiles(activeProfilesValue);
        }
        if (CoreUtil.isNullOrEmpty((List)(newProjects = projectConfigurationManager.createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration = new ProjectImportConfiguration(resolverConfig), monitor)))) {
            retval = LiferayMavenCore.createErrorStatus("New project was not created due to unknown error");
        } else {
            if (!CoreUtil.isNullOrEmpty((String)activeProfilesValue)) {
                String[] activeProfiles = activeProfilesValue.split(",");
                List<NewLiferayProfile> newUserSettingsProfiles = this.getNewProfilesToSave(activeProfiles, (List<NewLiferayProfile>)op.getNewLiferayProfiles(), ProfileLocation.userSettings);
                if (newUserSettingsProfiles.size() > 0) {
                    String userSettingsFile = mavenConfiguration.getUserSettingsFile();
                    String userSettingsPath = null;
                    userSettingsPath = CoreUtil.isNullOrEmpty((String)userSettingsFile) ? MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath() : userSettingsFile;
                    try {
                        File settingsXmlFile = new File(userSettingsPath);
                        File backupFile = this.getBackupFile(settingsXmlFile);
                        FileUtils.copyFile((File)settingsXmlFile, (File)backupFile);
                        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                        Document pomDocument = docBuilder.parse(settingsXmlFile.getCanonicalPath());
                        for (NewLiferayProfile newProfile : newUserSettingsProfiles) {
                            MavenUtil.createNewLiferayProfileNode(pomDocument, newProfile, archetypeVersion);
                        }
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        DOMSource source = new DOMSource(pomDocument);
                        StreamResult result = new StreamResult(settingsXmlFile);
                        transformer.transform(source, result);
                    }
                    catch (Exception e) {
                        LiferayMavenCore.logError("Unable to save new Liferay profile to user settings.xml.", e);
                    }
                }
                List<NewLiferayProfile> newProjectPomProfiles = this.getNewProfilesToSave(activeProfiles, (List<NewLiferayProfile>)op.getNewLiferayProfiles(), ProfileLocation.projectPom);
                IProject newProject = (IProject)newProjects.get(0);
                IMavenProjectFacade newMavenProject = mavenProjectRegistry.getProject(newProject);
                IFile pomFile = newMavenProject.getPom();
                try {
                    IDOMModel domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(pomFile);
                    for (NewLiferayProfile newProfile : newProjectPomProfiles) {
                        MavenUtil.createNewLiferayProfileNode((Document)domModel.getDocument(), newProfile, archetypeVersion);
                    }
                    domModel.save();
                    domModel.releaseFromEdit();
                }
                catch (IOException e) {
                    LiferayMavenCore.logError("Unable to save new Liferay profiles to project pom.", e);
                }
                for (IProject project : newProjects) {
                    try {
                        projectConfigurationManager.updateProjectConfiguration(new MavenUpdateRequest(project, mavenConfiguration.isOffline(), true), monitor);
                    }
                    catch (Exception e) {
                        LiferayMavenCore.logError("Unable to update configuration for " + project.getName(), e);
                    }
                }
            }
            if (((PluginType)op.getPluginType().content()).equals((Object)PluginType.portlet)) {
                retval = ((IPortletFramework)op.getPortletFramework().content()).postProjectCreated((IProject)newProjects.get(0), frameworkName, monitor);
            }
        }
        if (retval == null) {
            retval = Status.OK_STATUS;
        }
        return retval;
    }

    private File getBackupFile(File file) {
        String suffix = new SimpleDateFormat("yyyyMMddhhmmss").format(Calendar.getInstance().getTime());
        return new File(file.getParentFile(), String.valueOf(file.getName()) + "." + suffix);
    }

    public <T> List<T> getData(String key, Class<T> type, Object ... params) {
        ArrayList<T> retval = null;
        if ("profileIds".equals(key)) {
            ArrayList<T> profileIds = new ArrayList<T>();
            try {
                List profiles = MavenPlugin.getMaven().getSettings().getProfiles();
                for (Profile profile : profiles) {
                    if (profile.getActivation() != null && profile.getActivation().isActiveByDefault()) continue;
                    profileIds.add(type.cast(profile.getId()));
                }
                if (params[0] != null && params[0] instanceof File) {
                    File locationDir = (File)params[0];
                    File pomFile = new File(locationDir, "pom.xml");
                    if (!pomFile.exists() && locationDir.getParentFile().exists()) {
                        pomFile = new File(locationDir.getParentFile(), "pom.xml");
                    }
                    if (pomFile.exists()) {
                        IMaven maven = MavenPlugin.getMaven();
                        Model model = maven.readModel(pomFile);
                        File parentDir = pomFile.getParentFile();
                        while (model != null) {
                            for (org.apache.maven.model.Profile p : model.getProfiles()) {
                                profileIds.add(type.cast(p.getId()));
                            }
                            if ((parentDir = parentDir.getParentFile()) == null || !parentDir.exists()) continue;
                            try {
                                model = maven.readModel(new File(parentDir, "pom.xml"));
                            }
                            catch (Exception exception) {
                                model = null;
                            }
                        }
                    }
                }
            }
            catch (CoreException e) {
                LiferayMavenCore.logError(e);
            }
            retval = profileIds;
        } else if ("liferayVersions".equals(key)) {
            ArrayList<T> possibleVersions = new ArrayList<T>();
            RepositorySystem system = AetherUtil.newRepositorySystem();
            DefaultRepositorySystemSession session = AetherUtil.newRepositorySystemSession(system);
            String groupId = params[0].toString();
            String artifactId = params[1].toString();
            String coords = String.valueOf(groupId) + ":" + artifactId + ":[6,)";
            DefaultArtifact artifact = new DefaultArtifact(coords);
            VersionRangeRequest rangeRequest = new VersionRangeRequest();
            rangeRequest.setArtifact((Artifact)artifact);
            rangeRequest.addRepository(AetherUtil.newCentralRepository());
            rangeRequest.addRepository(AetherUtil.newLiferayRepository());
            try {
                VersionRangeResult rangeResult = system.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
                List versions = rangeResult.getVersions();
                for (Version version : versions) {
                    String val = version.toString();
                    if ("6.2.0".equals(val)) continue;
                    possibleVersions.add(type.cast(val));
                }
                retval = possibleVersions;
            }
            catch (VersionRangeResolutionException versionRangeResolutionException) {}
        } else if ("parentVersion".equals(key)) {
            ArrayList<T> version = new ArrayList<T>();
            File locationDir = (File)params[0];
            File parentPom = new File(locationDir, "pom.xml");
            if (parentPom.exists()) {
                try {
                    IMaven maven = MavenPlugin.getMaven();
                    Model model = maven.readModel(parentPom);
                    version.add(type.cast(model.getVersion()));
                    retval = version;
                }
                catch (CoreException e) {
                    LiferayMavenCore.logError("unable to get parent version", e);
                }
            }
        }
        return retval;
    }

    private List<NewLiferayProfile> getNewProfilesToSave(String[] activeProfiles, List<NewLiferayProfile> newLiferayProfiles, ProfileLocation location) {
        ArrayList<NewLiferayProfile> profilesToSave = new ArrayList<NewLiferayProfile>();
        String[] stringArray = activeProfiles;
        int n = activeProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            String activeProfile = stringArray[n2];
            for (NewLiferayProfile newProfile : newLiferayProfiles) {
                if (!activeProfile.equals(newProfile.getId().content()) || !((ProfileLocation)newProfile.getProfileLocation().content()).equals((Object)location)) continue;
                profilesToSave.add(newProfile);
            }
            ++n2;
        }
        return profilesToSave;
    }

    public ILiferayProject provide(Object type) {
        if (type instanceof IProject) {
            IProject project = (IProject)type;
            try {
                if (MavenUtil.isMavenProject(project)) {
                    return new LiferayMavenProject(project);
                }
            }
            catch (CoreException e) {
                LiferayMavenCore.logError("Unable to create ILiferayProject from maven project " + project.getName(), e);
            }
        }
        return null;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval;
        block7: {
            retval = Status.OK_STATUS;
            File dir = path.toFile();
            if (dir.exists()) {
                File pomFile = path.append("pom.xml").toFile();
                if (pomFile.exists()) {
                    IMaven maven = MavenPlugin.getMaven();
                    try {
                        Model result = maven.readModel(pomFile);
                        if (!"pom".equals(result.getPackaging())) {
                            retval = LiferayMavenCore.createErrorStatus("\"" + pomFile.getParent() + "\" contains a non-parent maven project.");
                            break block7;
                        }
                        IPath newProjectPath = path.append(projectName);
                        retval = this.validateProjectLocation(projectName, newProjectPath);
                    }
                    catch (CoreException e) {
                        retval = LiferayMavenCore.createErrorStatus("Invalid project location.", e);
                        LiferayMavenCore.log(retval);
                    }
                } else {
                    File[] files = dir.listFiles();
                    if (files.length > 0) {
                        retval = LiferayMavenCore.createErrorStatus("Project location is not empty or a parent pom.");
                    }
                }
            }
        }
        return retval;
    }
}

