/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.maven.core.BuildCSSBuildParticipant;
import com.liferay.ide.maven.core.BuildThumbnailBuildParticipant;
import com.liferay.ide.maven.core.ThemeMergeBuildParticipant;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;

public class LiferayProjectLifecycleConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        if (this.isLiferayMavenThemePluginExecution(execution)) {
            String goal = execution.getGoal();
            if ("theme-merge".equals(goal)) {
                return new ThemeMergeBuildParticipant();
            }
            if ("build-css".equals(goal)) {
                return new BuildCSSBuildParticipant();
            }
            if ("build-thumbnail".equals(goal)) {
                return new BuildThumbnailBuildParticipant();
            }
        } else {
            this.isLiferayMavenExtPluginExecution(execution);
        }
        return null;
    }

    private boolean isLiferayMavenExtPluginExecution(MojoExecution execution) {
        String groupId = execution.getGroupId();
        String artifactId = execution.getArtifactId();
        String goal = execution.getGoal();
        return "com.liferay.maven.plugins".equals(groupId) && "liferay-maven-plugin".equals(artifactId) && "build-ext".equals(goal);
    }

    private boolean isLiferayMavenThemePluginExecution(MojoExecution execution) {
        String groupId = execution.getGroupId();
        String artifactId = execution.getArtifactId();
        String goal = execution.getGoal();
        return "com.liferay.maven.plugins".equals(groupId) && "liferay-maven-plugin".equals(artifactId) && ("build-css".equals(goal) || "theme-merge".equals(goal) || "build-thumbnail".equals(goal));
    }
}

