/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.widgets;

import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DisplayTools {
    public static void asyncExec(Runnable runnable) {
        Display display = DisplayTools.getDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public static void syncExec(Runnable runnable) {
        Display display = DisplayTools.getDisplay();
        if (display != null) {
            display.syncExec(runnable);
        }
    }

    public static void delayedExec(Runnable runnable) {
        DisplayTools.timerExec(OpenStrategy.getPostSelectionDelay(), runnable);
    }

    public static void timerExec(int milliseconds, Runnable runnable) {
        Display display = DisplayTools.getDisplay();
        if (display != null) {
            display.timerExec(milliseconds, runnable);
        }
    }

    public static void execute(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display != null) {
            runnable.run();
        } else {
            display = WorkbenchTools.getDisplay();
            if (display != null) {
                display.asyncExec(runnable);
            }
        }
    }

    public static void execute(Viewer viewer, Runnable runnable) {
        DisplayTools.execute(viewer.getControl(), runnable);
    }

    public static void execute(Control control, Runnable runnable) {
        DisplayTools.execute(control.getDisplay(), runnable);
    }

    public static void execute(Display display, Runnable runnable) {
        if (display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.asyncExec(runnable);
        }
    }

    public static Shell getShell() {
        Shell shell = DisplayTools.getActiveShell();
        return shell != null ? shell : WorkbenchTools.getActiveShell();
    }

    public static Shell getActiveShell() {
        Display display = DisplayTools.getDisplay();
        return display == null ? null : display.getActiveShell();
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        return display != null ? display : WorkbenchTools.getDisplay();
    }

    public static boolean uiThread() {
        return Display.getCurrent() != null;
    }

    public static boolean uiThread(Viewer viewer) {
        return DisplayTools.uiThread((Widget)viewer.getControl());
    }

    public static boolean uiThread(Widget widget) {
        return widget.getDisplay().getThread() == Thread.currentThread();
    }

    private DisplayTools() {
        throw new UnsupportedOperationException();
    }
}

