/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.fm;

import com.liferay.ide.debug.core.LiferayDebugCore;
import com.liferay.ide.debug.core.fm.FMDebugTarget;
import freemarker.debug.DebugModel;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IVariable;

public class FMDebugElement
extends PlatformObject
implements IDebugElement {
    private FMDebugTarget target;

    public FMDebugElement(FMDebugTarget target) {
        this.target = target;
    }

    protected void abort(String message, Throwable e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, LiferayDebugCore.getDefault().getBundle().getSymbolicName(), 120, message, e));
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDebugElement.class) {
            return this;
        }
        if (adapter == ILaunch.class) {
            return this.getDebugTarget().getLaunch();
        }
        return super.getAdapter(adapter);
    }

    public FMDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public String getModelIdentifier() {
        return "com.liferay.ide.debug.freemarker";
    }

    protected String getReferenceTypeName(DebugModel model) throws DebugException {
        try {
            switch (model.getModelTypes()) {
                case 8: {
                    return "boolean";
                }
                case 32: {
                    return "collection";
                }
                case 8192: {
                    return "configuration";
                }
                case 4: {
                    return "date";
                }
                case 2048: {
                    return "environment";
                }
                case 64: {
                    return "hash";
                }
                case 128: {
                    return "hash_ex";
                }
                case 256: {
                    return "method";
                }
                case 512: {
                    return "method_ex";
                }
                case 2: {
                    return "number";
                }
                case 1: {
                    return "scalar";
                }
                case 16: {
                    return "sequence";
                }
                case 4096: {
                    return "template";
                }
                case 1024: {
                    return "transform";
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return "var";
    }

    protected void sortVariables(IVariable[] variables) {
        Arrays.sort(variables, new Comparator<IVariable>(){

            @Override
            public int compare(IVariable var1, IVariable var2) {
                try {
                    return var1.getName().compareTo(var2.getName());
                }
                catch (DebugException debugException) {
                    return 0;
                }
            }
        });
    }
}

