/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.fm;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.debug.core.LiferayDebugCore;
import com.liferay.ide.debug.core.fm.FMDebugElement;
import com.liferay.ide.debug.core.fm.FMThread;
import com.liferay.ide.debug.core.fm.FMVariable;
import com.liferay.ide.debug.core.fm.TemplateVMValue;
import freemarker.debug.DebuggedEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class FMStackFrame
extends FMDebugElement
implements IStackFrame {
    static final Pattern freemarkerClasses = Pattern.compile("^freemarker\\..*\\$.*$");
    static final Pattern liferayClasses = Pattern.compile("^com\\.liferay\\.portal\\.freemarker\\.LiferayObjectWrapper$");
    static final Pattern liferaySpringClasses = Pattern.compile("^com\\.liferay\\..*@[a-z0-9]+$");
    static final Pattern classDefs = Pattern.compile("^public void com\\.liferay.*$");
    private String name;
    private FMThread thread;
    private IVariable[] variables;

    public FMStackFrame(FMThread thread, String name) {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.name = name;
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    void clearVariables() {
        this.variables = null;
    }

    private boolean filter(IVariable var) {
        try {
            String valueString;
            String name = var.getName();
            if (this.filterVariableName(name) && this.filterVariableValueString(valueString = var.getValue().getValueString())) {
                return true;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    private boolean filterVariableName(String variableName) {
        boolean retval = true;
        return retval;
    }

    private IVariable[] filterVariables(IVariable[] variables) {
        ArrayList<IVariable> filtered = new ArrayList<IVariable>();
        IVariable[] iVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            if (this.filter(var)) {
                filtered.add(var);
            }
            ++n2;
        }
        IVariable[] retval = filtered.toArray(new IVariable[0]);
        return retval;
    }

    private boolean filterVariableValueString(String valueString) {
        return !liferaySpringClasses.matcher(valueString).matches() && !freemarkerClasses.matcher(valueString).matches() && !liferayClasses.matcher(valueString).matches() && !classDefs.matcher(valueString).matches();
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        int retval = -1;
        if (this.thread != null && this.thread.isSuspended()) {
            Object[] lineBreakpoints = this.thread.getBreakpoints();
            if (!CoreUtil.isNullOrEmpty((Object[])lineBreakpoints)) {
                Object bp = lineBreakpoints[0];
                if (bp instanceof ILineBreakpoint) {
                    ILineBreakpoint lineBp = (ILineBreakpoint)bp;
                    try {
                        retval = lineBp.getLineNumber();
                    }
                    catch (CoreException e) {
                        LiferayDebugCore.logError("Could not get breakpoint charStart", (Exception)((Object)e));
                    }
                }
            } else if (this.thread.getStepBreakpoint() != null) {
                retval = this.thread.getStepBreakpoint().getLine();
            }
        }
        return retval;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public FMThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.variables == null) {
            boolean advancedView = LiferayDebugCore.getPrefs().getBoolean("advanced-variables-view", false);
            DebuggedEnvironment env = this.thread.getEnvironment();
            FMVariable[] topLevelVars = null;
            try {
                topLevelVars = new FMVariable[]{new FMVariable(this, "currentNamespace", env.get("currentNamespace")), new FMVariable(this, "dataModel", env.get("dataModel")), new FMVariable(this, "globalNamespace", env.get("globalNamespace")), new FMVariable(this, "knownVariables", env.get("knownVariables")), new FMVariable(this, "mainNamespace", env.get("mainNamespace")), new FMVariable(this, "template", env.get("template")){

                    public IValue getValue() throws DebugException {
                        return new TemplateVMValue(this.stackFrame, this.debugModel);
                    }
                }};
            }
            catch (Exception e) {
                LiferayDebugCore.logError("Unable to create freemarker variables", e);
            }
            if (topLevelVars != null) {
                if (advancedView) {
                    this.variables = topLevelVars;
                } else {
                    HashMap<String, IVariable> vars = new HashMap<String, IVariable>();
                    FMVariable[] fMVariableArray = topLevelVars;
                    int n = topLevelVars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        void topLevelVar = fMVariableArray[n2];
                        IVariable[] iVariableArray = topLevelVar.getValue().getVariables();
                        int n3 = iVariableArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IVariable nestedVar = iVariableArray[n4];
                            IVariable existingVar = (IVariable)vars.get(nestedVar.getName());
                            if (existingVar == null) {
                                vars.put(nestedVar.getName(), nestedVar);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    this.variables = this.filterVariables(vars.values().toArray(new IVariable[0]));
                    this.sortVariables(this.variables);
                }
            }
        }
        return this.variables;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables != null && this.variables.length > 0;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public void suspendJavaThread() throws DebugException {
        this.getDebugTarget().suspendRelatedJavaThread(this.getThread().getThreadId());
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }
}

