/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.fm;

import com.liferay.ide.debug.core.fm.FMDebugElement;
import com.liferay.ide.debug.core.fm.FMDebugTarget;
import freemarker.debug.Breakpoint;
import freemarker.debug.DebuggedEnvironment;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class FMThread
extends FMDebugElement
implements IThread {
    private IBreakpoint[] breakpoints;
    private Breakpoint stepBreakpoint;
    private boolean stepping = false;
    private DebuggedEnvironment suspendedEnvironment;
    private long threadId = -1L;

    public FMThread(FMDebugTarget fmDebugTarget) {
        super(fmDebugTarget);
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean canTerminate() {
        return false;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.breakpoints;
    }

    public DebuggedEnvironment getEnvironment() {
        return this.suspendedEnvironment;
    }

    public String getName() throws DebugException {
        return "FM Engine";
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return this.getDebugTarget().getStackFrames();
        }
        return new IStackFrame[0];
    }

    public Breakpoint getStepBreakpoint() {
        return this.stepBreakpoint;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume(this);
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.breakpoints = breakpoints;
    }

    public void setEnvironment(DebuggedEnvironment environment) {
        this.suspendedEnvironment = environment;
    }

    public void setStepBreakpoint(Breakpoint bp) {
        this.stepBreakpoint = bp;
    }

    protected void setStepping(boolean stepping) {
        this.stepping = stepping;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
        this.getDebugTarget().step(this);
    }

    public void stepReturn() throws DebugException {
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }
}

