/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.fm;

import com.liferay.ide.debug.core.fm.FMDebugElement;
import com.liferay.ide.debug.core.fm.FMStackFrame;
import com.liferay.ide.debug.core.fm.FMVariable;
import freemarker.debug.DebugModel;
import freemarker.template.TemplateModelException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class FMValue
extends FMDebugElement
implements IValue {
    private static final int VALID_VARIBLE_TYPES = 12543;
    protected DebugModel debugModel;
    protected FMStackFrame stackFrame;
    private IVariable[] variables;

    public FMValue(FMStackFrame stackFrame, DebugModel debugModel) {
        super(stackFrame.getDebugTarget());
        this.stackFrame = stackFrame;
        this.debugModel = debugModel;
    }

    public String getValueString() throws DebugException {
        String retval = null;
        try {
            int types = this.debugModel.getModelTypes();
            if ((8 & types) > 0) {
                retval = Boolean.toString(this.debugModel.getAsBoolean());
            }
            if ((0x20 & types) > 0) {
                retval = "Collection";
            }
            if ((0x2000 & types) > 0) {
                retval = "Configuration";
            }
            if ((4 & types) > 0) {
                retval = this.debugModel.getAsDate().toString();
            }
            if ((0x800 & types) > 0) {
                retval = "Environment";
            }
            if ((0x40 & types) > 0) {
                retval = "Hash";
            }
            if ((0x80 & types) > 0) {
                retval = "HashEx";
            }
            if ((2 & types) > 0) {
                retval = this.debugModel.getAsNumber().toString();
            }
            if ((1 & types) > 0) {
                retval = this.debugModel.getAsString();
            }
            if ((0x10 & types) > 0) {
                retval = "Sequence";
            }
            if ((0x1000 & types) > 0) {
                retval = "Template";
            }
            if ((0x400 & types) > 0) {
                retval = "Transform";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (retval == null) {
            retval = "";
        }
        return retval;
    }

    private String getCollectionDetailString(DebugModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        try {
            int i = 0;
            while (i < model.size()) {
                DebugModel val = model.get(i);
                String value = this.getModelDetailString(val);
                if (value != null) {
                    sb.append(value);
                    sb.append(',');
                }
                ++i;
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
        }
        String value = sb.toString();
        return value.endsWith(",") ? value.replaceFirst(",$", "]") : value;
    }

    private String getSequenceDetailString(DebugModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        try {
            int i = 0;
            while (i < model.size()) {
                DebugModel val = model.get(i);
                String value = this.getModelDetailString(val);
                if (value != null) {
                    sb.append(value);
                    sb.append(',');
                }
                ++i;
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
        }
        String value = sb.toString();
        return value.endsWith(",") ? value.replaceFirst(",$", "]") : value;
    }

    private String getModelDetailString(DebugModel model) throws RemoteException, TemplateModelException {
        String value = null;
        int modelTypes = model.getModelTypes();
        if (this.isStringType(modelTypes) && !this.isHashType(modelTypes)) {
            value = model.getAsString();
        } else if (this.isNumberType(modelTypes)) {
            value = model.getAsNumber().toString();
        } else if (this.isDateType(modelTypes)) {
            value = model.getAsDate().toString();
        } else if (this.isBooleanType(modelTypes)) {
            value = Boolean.toString(model.getAsBoolean());
        } else if (this.isHashType(modelTypes)) {
            value = "Hash";
        } else if (this.isCollectionType(modelTypes)) {
            value = "Collection";
        } else if (this.isSequenceType(modelTypes)) {
            value = "Sequence";
        } else if (this.isMethodType(modelTypes) || this.isTransformType(modelTypes) || modelTypes == 0) {
            value = null;
        } else {
            System.out.println("unsupported detail model type: " + modelTypes);
        }
        return value;
    }

    public String getDetailString() {
        String retval = null;
        try {
            int types = this.debugModel.getModelTypes();
            if ((8 & types) > 0) {
                retval = Boolean.toString(this.debugModel.getAsBoolean());
            }
            if ((0x20 & types) > 0) {
                retval = this.getCollectionDetailString(this.debugModel);
            }
            if ((0x2000 & types) > 0) {
                retval = "Configuration";
            }
            if ((4 & types) > 0) {
                retval = this.debugModel.getAsDate().toString();
            }
            if ((0x800 & types) > 0) {
                retval = "Environment";
            }
            if ((0x40 & types) > 0) {
                retval = "Hash";
            }
            if ((0x80 & types) > 0) {
                retval = this.getHashDetailString(this.debugModel);
            }
            if ((2 & types) > 0) {
                retval = this.debugModel.getAsNumber().toString();
            }
            if ((1 & types) > 0) {
                retval = this.debugModel.getAsString();
            }
            if ((0x10 & types) > 0) {
                retval = this.getSequenceDetailString(this.debugModel);
            }
            if ((0x1000 & types) > 0) {
                retval = "Template";
            }
            if ((0x400 & types) > 0) {
                retval = "Transform";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (retval == null) {
            retval = "";
        }
        return retval;
    }

    private String getHashDetailString(DebugModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        try {
            String[] stringArray = model.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                DebugModel val = model.get(key);
                String value = this.getModelDetailString(val);
                if (value != null) {
                    sb.append(key);
                    sb.append('=');
                    sb.append(value);
                    sb.append(',');
                }
                ++n2;
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
        }
        String value = sb.toString();
        return value.endsWith(",") ? value.replaceFirst(",$", "}") : value;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.variables == null) {
            ArrayList<FMVariable> vars;
            block14: {
                vars = new ArrayList<FMVariable>();
                try {
                    int types = this.debugModel.getModelTypes();
                    if (this.isHashType(types)) {
                        try {
                            String[] keys = this.debugModel.keys();
                            DebugModel[] vals = this.debugModel.get(keys);
                            int i = 0;
                            while (i < keys.length) {
                                DebugModel hashValue = vals[i];
                                if (this.isValidVariable(hashValue)) {
                                    vars.add(new FMVariable(this.stackFrame, keys[i], hashValue));
                                }
                                ++i;
                            }
                            break block14;
                        }
                        catch (ClassCastException classCastException) {}
                        break block14;
                    }
                    if (!this.isCollectionType(types)) {
                        if (this.isSequenceType(types) && this.isValidSequence(this.debugModel)) {
                            int length = this.debugModel.size();
                            DebugModel[] vals = this.debugModel.get(0, length);
                            int i = 0;
                            while (i < length) {
                                if (this.isValidVariable(vals[i])) {
                                    vars.add(new FMVariable(this.stackFrame, Integer.toString(i), vals[i]));
                                }
                                ++i;
                            }
                        } else if (!(this.isStringType(types) || this.isNumberType(types) || this.isBooleanType(types) || this.isDateType(types))) {
                            System.out.println("Unknown value: " + this.getReferenceTypeName(this.debugModel));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.variables = vars.toArray(new IVariable[vars.size()]);
            this.sortVariables(this.variables);
        }
        return this.variables;
    }

    private boolean isValidSequence(DebugModel model) {
        try {
            return model != null && model.size() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isHashType(int types) {
        return (0x40 & types) > 0 || (0x80 & types) > 0;
    }

    private boolean isMethodType(int types) {
        return (0x100 & types) > 0 || (0x200 & types) > 0;
    }

    private boolean isTransformType(int types) {
        return (0x400 & types) > 0;
    }

    private boolean isStringType(int types) {
        return (1 & types) > 0;
    }

    private boolean isNumberType(int types) {
        return (2 & types) > 0;
    }

    private boolean isDateType(int types) {
        return (4 & types) > 0;
    }

    private boolean isBooleanType(int types) {
        return (8 & types) > 0;
    }

    private boolean isCollectionType(int types) {
        return (0x20 & types) > 0;
    }

    private boolean isSequenceType(int types) {
        return (0x10 & types) > 0;
    }

    private boolean isValidVariable(DebugModel model) {
        boolean retval = false;
        if (model != null) {
            try {
                int types = model.getModelTypes();
                boolean bl = retval = (0x30FF & types) > 0;
                if (retval && this.isSequenceType(types) && !this.isValidSequence(model)) {
                    retval = false;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    public boolean hasVariables() throws DebugException {
        try {
            return this.getVariables().length > 0;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getReferenceTypeName(this.debugModel);
    }
}

