/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.util;

import com.liferay.ide.debug.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JPSUtil {
    private static final Logger _logger = Logger.getLogger(JPSUtil.class.getName());

    public static long getPid(String processName) {
        return JPSUtil.getPid(processName, null, null, null);
    }

    public static long getPid(String processName, String arguments) {
        return JPSUtil.getPid(processName, arguments, null, null);
    }

    public static long getPid(String processName, String host, String port) {
        return JPSUtil.getPid(processName, host, port);
    }

    public static long getPid(String processName, String arguments, String host, String port) {
        long pid;
        block28: {
            boolean remote;
            boolean bl = remote = host != null && port != null;
            if (remote) {
                _logger.log(Level.INFO, "Finding pid for process with name : {0}, arguments : {1}, host : {2}, port : {3}.", new Object[]{processName, arguments, host, port});
            } else {
                _logger.log(Level.INFO, "Finding pid for process with name : {0}, arguments : {1}.", new Object[]{processName, arguments});
            }
            Process jpsProcess = null;
            BufferedReader reader = null;
            pid = -1L;
            try {
                try {
                    ProcessBuilder processBuilder = null;
                    processBuilder = remote ? new ProcessBuilder("jps", "-m", String.valueOf(host) + ":" + port) : new ProcessBuilder("jps", "-m");
                    jpsProcess = processBuilder.start();
                    reader = new BufferedReader(new InputStreamReader(jpsProcess.getInputStream()));
                    String readLine = null;
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((readLine = reader.readLine()) != null) {
                        lines.add(readLine);
                        _logger.log(Level.INFO, "jps echo : [{0}]", readLine);
                    }
                    for (String line : lines) {
                        List<String> elements = StringUtil.split(line, " ");
                        if (arguments != null && elements.size() >= 3) {
                            if (!elements.get(1).equalsIgnoreCase(processName) || !elements.get(2).equalsIgnoreCase(arguments)) continue;
                            try {
                                pid = Long.parseLong(elements.get(0));
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                continue;
                            }
                        }
                        if (elements.size() < 2 || !elements.get(1).equalsIgnoreCase(processName)) continue;
                        try {
                            pid = Long.parseLong(elements.get(0));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (IOException ioe) {
                    _logger.log(Level.SEVERE, "Fail to find process with name : " + processName, ioe);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe2) {
                            _logger.log(Level.SEVERE, "Fail to close process InputStream.", ioe2);
                        }
                    }
                    if (jpsProcess != null) {
                        jpsProcess.destroy();
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.SEVERE, "Fail to close process InputStream.", ioe);
                    }
                }
                if (jpsProcess != null) {
                    jpsProcess.destroy();
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    _logger.log(Level.SEVERE, "Fail to close process InputStream.", ioe);
                }
            }
            if (jpsProcess != null) {
                jpsProcess.destroy();
            }
        }
        if (pid == -1L) {
            _logger.log(Level.WARNING, "No process with name : {0} is found.", processName);
        } else {
            _logger.log(Level.INFO, "Found process with name : {0}, pid is : {1}", new Object[]{processName, pid});
        }
        return pid;
    }
}

