/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.util;

import com.liferay.ide.debug.core.util.JPSUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadUtil {
    private static final Logger _logger = Logger.getLogger(ThreadUtil.class.getName());

    public static String dump(long pid) {
        _logger.log(Level.INFO, "Dumping threads for process with id:{0}", pid);
        ProcessBuilder jstackProcessBuilder = new ProcessBuilder("jstack", "-l", Long.toString(pid));
        Process jstackProcess = null;
        try {
            jstackProcess = jstackProcessBuilder.start();
            InputStreamReader reader = new InputStreamReader(jstackProcess.getInputStream());
            StringBuilder sb = new StringBuilder();
            int ch = -1;
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            _logger.log(Level.INFO, "Dumped out threads for process with pid : {0} successfully.", pid);
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Fail to dump threads for process with id:" + pid, ex);
            return null;
        }
        finally {
            if (jstackProcess != null) {
                jstackProcess.destroy();
            }
        }
    }

    public static String dump(String processName) {
        long pid = JPSUtil.getPid(processName);
        if (pid == -1L) {
            _logger.log(Level.SEVERE, "Fail to find process with name:{0}, abort dumping process", processName);
            return null;
        }
        return ThreadUtil.dump(pid);
    }

    public static void dump(String processName, String dir) {
        File dumpFile;
        block15: {
            Date date = new Date();
            String threadDump = ThreadUtil.dump(processName);
            if (threadDump == null) {
                return;
            }
            dumpFile = new File(dir, String.valueOf(date.toString()) + ".tdump");
            FileWriter fileWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(dumpFile);
                    fileWriter.write(threadDump);
                    fileWriter.flush();
                }
                catch (IOException ioe) {
                    _logger.log(Level.SEVERE, "Fail to write thread dump.", ioe);
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException ioe2) {
                            _logger.log(Level.SEVERE, "Fail to close thread dump file writer.", ioe2);
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.SEVERE, "Fail to close thread dump file writer.", ioe);
                    }
                }
                throw throwable;
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException ioe) {
                    _logger.log(Level.SEVERE, "Fail to close thread dump file writer.", ioe);
                }
            }
        }
        _logger.log(Level.INFO, "Saved thread dump to file : {0}.", dumpFile.getAbsolutePath());
    }
}

