/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.util.CoreUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NodeUtil {
    public static Element appendChildElement(Element parentElement, String newElementName) {
        return NodeUtil.appendChildElement(parentElement, newElementName, null);
    }

    public static Element appendChildElement(Element parentElement, String newElementName, String initialTextContent) {
        Element newChildElement = null;
        if (parentElement != null && newElementName != null) {
            Document ownerDocument = parentElement.getOwnerDocument();
            newChildElement = ownerDocument.createElement(newElementName);
            if (initialTextContent != null) {
                newChildElement.appendChild(ownerDocument.createTextNode(initialTextContent));
            }
            parentElement.appendChild(newChildElement);
        }
        return newChildElement;
    }

    public static Node appendTextNode(Element parentElement, String initialTextContent) {
        Text newChildElement = null;
        if (parentElement != null) {
            Document ownerDocument = parentElement.getOwnerDocument();
            newChildElement = ownerDocument.createTextNode(initialTextContent);
            parentElement.appendChild(newChildElement);
        }
        return newChildElement;
    }

    public static Element findChildElement(Element parentElement, String elementName) {
        Element retval = null;
        if (parentElement == null) {
            return retval;
        }
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && child.getNodeName().equals(elementName)) {
                retval = (Element)child;
                break;
            }
            ++i;
        }
        return retval;
    }

    public static Node findFirstChild(Element element, String elementName) {
        NodeList children;
        if (element != null && !CoreUtil.isNullOrEmpty(elementName) && (children = element.getChildNodes()) != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (elementName.equals(child.getNodeName())) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    public static String getChildElementContent(Node parent, String childElement) {
        String retval = null;
        NodeList children = parent.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element && child.getNodeName().equals(childElement)) {
                    return NodeUtil.getTextContent((Element)child);
                }
                ++i;
            }
        }
        return retval;
    }

    public static Node getFirstNamedChildNode(Element element, String string) {
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node item = children.item(i);
                if (item.getNodeName().equals(string)) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    public static String getTextContent(Node node) {
        NodeList children = node.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            s.append(child.getNodeValue().trim());
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public static Element insertChildElement(Element parentElement, Node refNode, String newElementName, String initialTextContent) {
        Element newChildElement = null;
        if (parentElement != null && newElementName != null) {
            Document ownerDocument = parentElement.getOwnerDocument();
            newChildElement = ownerDocument.createElement(newElementName);
            if (initialTextContent != null) {
                newChildElement.appendChild(ownerDocument.createTextNode(initialTextContent));
            }
            parentElement.insertBefore(newChildElement, refNode);
        }
        return newChildElement;
    }

    public static void removeChildren(Element element) {
        while (element != null && element.hasChildNodes()) {
            element.removeChild(element.getFirstChild());
        }
    }

    public static void removeChildren(Node node) {
        if (node == null || node.getChildNodes() == null || node.getChildNodes().getLength() <= 0) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            node.removeChild(children.item(i));
            ++i;
        }
    }

    public static Text setTextContent(Node namespaceNode, String textContent) {
        Text retval = null;
        if (namespaceNode instanceof Text) {
            namespaceNode.setNodeValue(textContent);
            retval = (Text)namespaceNode;
        } else if (namespaceNode instanceof Element) {
            Element namespaceElement = (Element)namespaceNode;
            NodeUtil.removeChildren(namespaceElement);
            retval = namespaceElement.getOwnerDocument().createTextNode(textContent);
            namespaceElement.appendChild(retval);
        }
        return retval;
    }
}

