/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.help.IContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementImpl;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.MasterVersionCompatibilityService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PartFunctionContext;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.ProblemOverlayImageDescriptor;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.def.ISapphireParam;
import org.eclipse.sapphire.ui.def.ISapphirePartListenerDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.forms.ActuatorDef;
import org.eclipse.sapphire.ui.forms.ActuatorPart;
import org.eclipse.sapphire.ui.forms.CompositeDef;
import org.eclipse.sapphire.ui.forms.CompositePart;
import org.eclipse.sapphire.ui.forms.CustomFormComponentDef;
import org.eclipse.sapphire.ui.forms.DetailSectionDef;
import org.eclipse.sapphire.ui.forms.DetailSectionPart;
import org.eclipse.sapphire.ui.forms.DialogDef;
import org.eclipse.sapphire.ui.forms.DialogPart;
import org.eclipse.sapphire.ui.forms.FormComponentRef;
import org.eclipse.sapphire.ui.forms.FormDef;
import org.eclipse.sapphire.ui.forms.FormEditorPageDef;
import org.eclipse.sapphire.ui.forms.FormEditorPagePart;
import org.eclipse.sapphire.ui.forms.FormPart;
import org.eclipse.sapphire.ui.forms.GroupDef;
import org.eclipse.sapphire.ui.forms.GroupPart;
import org.eclipse.sapphire.ui.forms.HtmlPanelDef;
import org.eclipse.sapphire.ui.forms.HtmlPanelPart;
import org.eclipse.sapphire.ui.forms.LineSeparatorDef;
import org.eclipse.sapphire.ui.forms.LineSeparatorPart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPageDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.forms.PropertyEditorDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.SectionDef;
import org.eclipse.sapphire.ui.forms.SectionPart;
import org.eclipse.sapphire.ui.forms.SectionRef;
import org.eclipse.sapphire.ui.forms.SpacerDef;
import org.eclipse.sapphire.ui.forms.SpacerPart;
import org.eclipse.sapphire.ui.forms.SplitFormDef;
import org.eclipse.sapphire.ui.forms.SplitFormPart;
import org.eclipse.sapphire.ui.forms.SplitFormSectionDef;
import org.eclipse.sapphire.ui.forms.SplitFormSectionPart;
import org.eclipse.sapphire.ui.forms.StaticTextFieldDef;
import org.eclipse.sapphire.ui.forms.StaticTextFieldPart;
import org.eclipse.sapphire.ui.forms.TabGroupDef;
import org.eclipse.sapphire.ui.forms.TabGroupPart;
import org.eclipse.sapphire.ui.forms.TextDef;
import org.eclipse.sapphire.ui.forms.TextPart;
import org.eclipse.sapphire.ui.forms.WithDef;
import org.eclipse.sapphire.ui.forms.WithImpliedPart;
import org.eclipse.sapphire.ui.forms.WithPart;
import org.eclipse.sapphire.ui.forms.WizardPageDef;
import org.eclipse.sapphire.ui.forms.WizardPagePart;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.internal.PartServiceContext;
import org.eclipse.swt.widgets.Display;

public abstract class SapphirePart
implements ISapphirePart {
    @Text(value="Failed while instantiating {0} class.")
    private static LocalizableText failedToInstantiate;
    @Text(value="Class {0} does not extend the required Listener class.")
    private static LocalizableText doesNotExtend;
    @Text(value="Could not resolve form part include \"{0}\".")
    private static LocalizableText couldNotResolveInclude;
    @Text(value="Could not resolve section \"{0}\".")
    private static LocalizableText couldNotResolveSection;
    private ISapphirePart parent;
    private Element modelElement;
    protected PartDef definition;
    protected Map<String, String> params;
    private Status validation;
    private final ListenerContext listeners = new ListenerContext();
    private Set<SapphirePartListener> listenersDeprecated;
    private SwtResourceCache imageCache;
    private Map<String, SapphireActionGroup> actions;
    private PartServiceContext serviceContext;
    private FunctionResult visibilityFunctionResult;
    private boolean visibilityFunctionInitializing;
    private boolean initialized;
    private boolean disposed;

    static {
        LocalizableText.init(SapphirePart.class);
    }

    public final boolean initialized() {
        return this.initialized;
    }

    public final void init(ISapphirePart parent, Element modelElement, PartDef definition, Map<String, String> params) {
        this.parent = parent;
        this.definition = definition;
        this.params = params;
        if (modelElement == null) {
            throw new IllegalArgumentException();
        }
        this.modelElement = modelElement;
    }

    public final void initialize() {
        this.listeners.coordinate(((ElementImpl)this.modelElement).listeners());
        for (ISapphirePartListenerDef listenerDefinition : this.definition.getListeners()) {
            JavaType listenerClass = (JavaType)listenerDefinition.getListenerClass().resolve();
            if (listenerClass == null) continue;
            Object listener = null;
            try {
                listener = ((Class)listenerClass.artifact()).newInstance();
            }
            catch (Exception e) {
                String msg = failedToInstantiate.format(new Object[]{listenerClass.name()});
                ((LoggingService)Sapphire.service(LoggingService.class)).logError(msg, (Throwable)e);
            }
            if (listener == null) continue;
            if (listener instanceof Listener) {
                this.attach(listener);
                continue;
            }
            String msg = doesNotExtend.format(new Object[]{listenerClass.name()});
            ((LoggingService)Sapphire.service(LoggingService.class)).logError(msg);
        }
        this.init();
        this.initialized = true;
        this.broadcast(new PartInitializationEvent(this));
    }

    protected void init() {
    }

    public final FunctionResult initExpression(Function function, Class<?> expectedType, Function defaultValue) {
        return this.initExpression(this.getLocalModelElement(), function, expectedType, defaultValue, null);
    }

    public final FunctionResult initExpression(Function function, Class<?> expectedType, Function defaultValue, Runnable refreshOp) {
        return this.initExpression(this.getLocalModelElement(), function, expectedType, defaultValue, refreshOp);
    }

    public final FunctionResult initExpression(Element element, Function function, Class<?> expectedType, Function defaultValue) {
        return this.initExpression(function, expectedType, defaultValue, null);
    }

    public final FunctionResult initExpression(Element element, Function function, Class<?> expectedType, Function defaultValue, final Runnable refreshOp) {
        Literal f = function == null ? Literal.NULL : function;
        f = FailSafeFunction.create((Function)f, (Function)Literal.create(expectedType), (Function)defaultValue);
        FunctionResult fr = f.evaluate((FunctionContext)new PartFunctionContext(this, element));
        if (refreshOp != null) {
            fr.attach(new Listener(){

                public void handle(Event event) {
                    Runnable notifyOfUpdateOperation = new Runnable(){

                        @Override
                        public void run() {
                            if (!SapphirePart.this.disposed() && !SapphirePart.this.getLocalModelElement().disposed()) {
                                refreshOp.run();
                            }
                        }
                    };
                    Display.getDefault().syncExec(notifyOfUpdateOperation);
                }
            });
        }
        return fr;
    }

    protected Function initVisibleWhenFunction() {
        return (Function)this.definition.getVisibleWhen().content();
    }

    protected static final Function createVersionCompatibleFunction(final Property property) {
        if (property != null) {
            final MasterVersionCompatibilityService service = (MasterVersionCompatibilityService)property.service(MasterVersionCompatibilityService.class);
            Function function = new Function(){

                public String name() {
                    return "VersionCompatible";
                }

                public FunctionResult evaluate(FunctionContext context) {
                    return new FunctionResult(this, context){
                        private Listener serviceListener;
                        private Listener propertyListener;

                        protected void init() {
                            this.serviceListener = new Listener(){

                                public void handle(Event event) {
                                    this.refresh();
                                }
                            };
                            service.attach(this.serviceListener);
                            this.propertyListener = new FilteredListener<PropertyContentEvent>(){

                                protected void handleTypedEvent(PropertyContentEvent event) {
                                    this.refresh();
                                }
                            };
                            if (property.definition() instanceof ImpliedElementProperty) {
                                property.element().attach(this.propertyListener, String.valueOf(property.name()) + "/*");
                            } else {
                                property.element().attach(this.propertyListener, property.name());
                            }
                        }

                        protected Object evaluate() {
                            if (!service.compatible() && property.empty()) {
                                return false;
                            }
                            return true;
                        }

                        public void dispose() {
                            super.dispose();
                            service.detach(this.serviceListener);
                            if (property.definition() instanceof ImpliedElementProperty) {
                                property.element().detach(this.propertyListener, String.valueOf(property.name()) + "/*");
                            } else {
                                property.element().detach(this.propertyListener, property.name());
                            }
                        }
                    };
                }
            };
            function.init(new Function[0]);
            return function;
        }
        return null;
    }

    @Override
    public PartDef definition() {
        return this.definition;
    }

    @Override
    public ISapphirePart parent() {
        return this.parent;
    }

    @Override
    public final <T> T nearest(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.nearest(partType);
        }
        return null;
    }

    @Override
    public final Element getModelElement() {
        return this.modelElement;
    }

    @Override
    public Element getLocalModelElement() {
        return this.modelElement;
    }

    public final Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public final Status validation() {
        if (this.validation == null) {
            this.refreshValidation();
        }
        return this.validation;
    }

    protected Status computeValidation() {
        return Status.createOkStatus();
    }

    protected final void refreshValidation() {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SapphirePart.this.refreshValidation();
                }
            });
            return;
        }
        Status newValidationState = this.computeValidation();
        if (newValidationState == null) {
            throw new IllegalStateException();
        }
        if (this.validation == null) {
            this.validation = newValidationState;
        } else if (!this.validation.equals((Object)newValidationState)) {
            this.validation = newValidationState;
            this.broadcast(new PartValidationEvent(this));
        }
    }

    public final boolean visible() {
        if (this.visibilityFunctionResult == null) {
            if (this.visibilityFunctionInitializing) {
                this.visibilityFunctionResult = Literal.FALSE.evaluate(new FunctionContext());
            } else {
                this.visibilityFunctionInitializing = true;
                try {
                    FunctionResult fr = this.initExpression(this.initVisibleWhenFunction(), Boolean.class, (Function)Literal.TRUE, new Runnable(){

                        @Override
                        public void run() {
                            SapphirePart.this.broadcast(new PartVisibilityEvent(SapphirePart.this));
                        }
                    });
                    boolean visibilityAccessedDuringInit = this.visibilityFunctionResult != null;
                    this.visibilityFunctionResult = fr;
                    if (visibilityAccessedDuringInit && ((Boolean)fr.value()).booleanValue()) {
                        this.broadcast(new PartVisibilityEvent(this));
                    }
                }
                finally {
                    this.visibilityFunctionInitializing = false;
                }
            }
        }
        return (Boolean)this.visibilityFunctionResult.value();
    }

    public boolean setFocus() {
        return false;
    }

    public boolean setFocus(ModelPath path) {
        return false;
    }

    public final boolean setFocus(String path) {
        return this.setFocus(new ModelPath(path));
    }

    @Override
    public IContext getDocumentationContext() {
        return null;
    }

    @Override
    public SwtResourceCache getSwtResourceCache() {
        if (this.imageCache == null) {
            this.imageCache = this.parent == null ? new SwtResourceCache() : this.parent.getSwtResourceCache();
        }
        return this.imageCache;
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    protected final void broadcast(Event event) {
        this.listeners.broadcast(event);
    }

    @Deprecated
    public final void addListener(SapphirePartListener listener) {
        if (this.listenersDeprecated == null) {
            this.listenersDeprecated = Collections.singleton(listener);
        } else {
            this.listenersDeprecated = new HashSet<SapphirePartListener>(this.listenersDeprecated);
            this.listenersDeprecated.add(listener);
        }
    }

    @Deprecated
    public final void removeListener(SapphirePartListener listener) {
        if (this.listenersDeprecated != null && this.listenersDeprecated.contains(listener)) {
            if (this.listenersDeprecated.size() == 1) {
                this.listenersDeprecated = null;
            } else {
                this.listenersDeprecated = new HashSet<SapphirePartListener>(this.listenersDeprecated);
                this.listenersDeprecated.remove(listener);
            }
        }
    }

    @Deprecated
    public final Set<SapphirePartListener> getListeners() {
        if (this.listenersDeprecated == null) {
            return Collections.emptySet();
        }
        return this.listenersDeprecated;
    }

    public final PropertyDef resolve(String propertyName) {
        return this.resolve(this.modelElement, propertyName);
    }

    public final PropertyDef resolve(Element modelElement, String propertyName) {
        return SapphirePart.resolve(modelElement, propertyName, this.params);
    }

    public static final PropertyDef resolve(Element modelElement, String propertyName, Map<String, String> params) {
        if (propertyName != null) {
            propertyName = SapphirePart.substituteParams(propertyName.trim(), params);
            ElementType type = modelElement.type();
            PropertyDef property = type.property(propertyName);
            if (property == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            return property;
        }
        return null;
    }

    public final String substituteParams(String str) {
        return SapphirePart.substituteParams(str, this.params);
    }

    public static final String substituteParams(String str, Map<String, String> params) {
        String result = str;
        if (str != null && str.contains("@{")) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                StringBuilder token = new StringBuilder();
                token.append("@{");
                token.append(param.getKey());
                token.append('}');
                result = result.replace(token, param.getValue());
            }
        }
        return result;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.emptySet();
    }

    @Override
    public String getMainActionContext() {
        Set<String> contexts = this.getActionContexts();
        if (!contexts.isEmpty()) {
            return contexts.iterator().next();
        }
        return null;
    }

    @Override
    public final SapphireActionGroup getActions() {
        String context = this.getMainActionContext();
        if (context != null) {
            return this.getActions(context);
        }
        return null;
    }

    @Override
    public final SapphireActionGroup getActions(String context) {
        if (this.actions == null) {
            this.actions = new HashMap<String, SapphireActionGroup>();
            for (String ctxt : this.getActionContexts()) {
                SapphireActionGroup actionsForContext = new SapphireActionGroup(this, ctxt);
                this.actions.put(ctxt.toLowerCase(), actionsForContext);
            }
        }
        return this.actions.get(context.toLowerCase());
    }

    @Override
    public final SapphireAction getAction(String id) {
        for (String context : this.getActionContexts()) {
            SapphireAction action = this.getActions(context).getAction(id);
            if (action == null) continue;
            return action;
        }
        if (this.parent != null) {
            return this.parent.getAction(id);
        }
        return null;
    }

    public boolean isSingleLinePart() {
        return false;
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        Element element;
        Object result = this.service(MasterConversionService.class).convert((Object)this, adapterType);
        if (result == null && (element = this.getLocalModelElement()) != null) {
            result = element.adapt(adapterType);
        }
        if (result == null && this.parent != null) {
            result = this.parent.adapt(adapterType);
        }
        return (A)result;
    }

    @Override
    public final <S extends Service> S service(Class<S> type) {
        List<S> services = this.services(type);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    @Override
    public final <S extends Service> List<S> services(Class<S> type) {
        if (this.serviceContext == null) {
            this.serviceContext = new PartServiceContext(this);
        }
        return this.serviceContext.services(type);
    }

    public final boolean executeAfterInitialization(final Runnable job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (this.initialized()) {
            job.run();
            return true;
        }
        this.attach((Listener)new FilteredListener<PartInitializationEvent>(){

            protected void handleTypedEvent(PartInitializationEvent event) {
                SapphirePart.this.detach((Listener)this);
                job.run();
            }
        });
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        boolean performOnDisposeTasks = false;
        SapphirePart sapphirePart = this;
        synchronized (sapphirePart) {
            if (!this.disposed) {
                this.disposed = true;
                performOnDisposeTasks = true;
            }
        }
        if (performOnDisposeTasks) {
            if (this.parent == null && this.imageCache != null) {
                this.imageCache.dispose();
            }
            if (this.actions != null) {
                for (SapphireActionGroup actionsForContext : this.actions.values()) {
                    actionsForContext.dispose();
                }
            }
            if (this.serviceContext != null) {
                this.serviceContext.dispose();
            }
            if (this.visibilityFunctionResult != null) {
                this.visibilityFunctionResult.dispose();
            }
            this.broadcast((Event)new DisposeEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disposed() {
        SapphirePart sapphirePart = this;
        synchronized (sapphirePart) {
            return this.disposed;
        }
    }

    public static final SapphirePart create(ISapphirePart parent, Element element, PartDef definition, Map<String, String> params) {
        SapphirePart part = SapphirePart.createWithoutInit(parent, element, definition, params);
        part.initialize();
        return part;
    }

    public static final SapphirePart createWithoutInit(ISapphirePart parent, Element element, PartDef definition, Map<String, String> params) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        SapphirePart part = null;
        Map<String, String> partParams = params;
        PartDef def = definition;
        if (definition instanceof PropertyEditorDef) {
            part = new PropertyEditorPart();
        } else if (definition instanceof TextDef) {
            part = new TextPart();
        } else if (definition instanceof LineSeparatorDef) {
            part = new LineSeparatorPart();
        } else if (definition instanceof SpacerDef) {
            part = new SpacerPart();
        } else if (definition instanceof ActuatorDef) {
            part = new ActuatorPart();
        } else if (definition instanceof CustomFormComponentDef) {
            JavaType customPartImplClass = (JavaType)((CustomFormComponentDef)definition).getImplClass().resolve();
            if (customPartImplClass != null) {
                try {
                    part = (SapphirePart)((Class)customPartImplClass.artifact()).newInstance();
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
        } else if (definition instanceof StaticTextFieldDef) {
            part = new StaticTextFieldPart();
        } else if (definition instanceof GroupDef) {
            part = new GroupPart();
        } else if (definition instanceof WithDef) {
            Property property;
            String path = ((SapphirePart)parent).substituteParams(((WithDef)definition).getPath().text());
            part = path.endsWith("..") ? new WithImpliedPart() : ((property = element.property(path)).definition() instanceof ImpliedElementProperty ? new WithImpliedPart() : new WithPart());
        } else if (definition instanceof DetailSectionDef) {
            part = new DetailSectionPart();
        } else if (definition instanceof DialogDef) {
            part = new DialogPart();
        } else if (definition instanceof WizardPageDef) {
            part = new WizardPagePart();
        } else if (definition instanceof SectionDef) {
            part = new SectionPart();
        } else {
            if (definition instanceof SectionRef) {
                SectionRef ref = (SectionRef)definition;
                def = (PartDef)ref.getSection().resolve();
                if (def == null) {
                    String msg = couldNotResolveSection.format(new Object[]{ref.getSection().text()});
                    throw new IllegalArgumentException(msg);
                }
                partParams = new HashMap<String, String>(params);
                for (ISapphireParam param : ref.getParams()) {
                    String paramName = param.getName().text();
                    String paramValue = param.getValue().text();
                    if (paramName == null || paramValue == null) continue;
                    partParams.put(paramName, paramValue);
                }
                return SapphirePart.createWithoutInit(parent, element, def, partParams);
            }
            if (definition instanceof FormComponentRef) {
                FormComponentRef inc = (FormComponentRef)definition;
                def = (PartDef)inc.getPart().resolve();
                if (def == null) {
                    String msg = couldNotResolveInclude.format(new Object[]{inc.getPart().text()});
                    throw new IllegalArgumentException(msg);
                }
                partParams = new HashMap<String, String>(params);
                for (ISapphireParam param : inc.getParams()) {
                    String paramName = param.getName().text();
                    String paramValue = param.getValue().text();
                    if (paramName == null || paramValue == null) continue;
                    partParams.put(paramName, paramValue);
                }
                return SapphirePart.createWithoutInit(parent, element, def, partParams);
            }
            if (definition instanceof TabGroupDef) {
                part = new TabGroupPart();
            } else if (definition instanceof HtmlPanelDef) {
                part = new HtmlPanelPart();
            } else if (definition instanceof SplitFormDef) {
                part = new SplitFormPart();
            } else if (definition instanceof SplitFormSectionDef) {
                part = new SplitFormSectionPart();
            } else if (definition instanceof CompositeDef) {
                part = new CompositePart();
            } else if (definition instanceof FormDef) {
                part = new FormPart();
            } else if (definition instanceof MasterDetailsEditorPageDef) {
                part = new MasterDetailsEditorPagePart();
            } else if (definition instanceof FormEditorPageDef) {
                part = new FormEditorPagePart();
            }
        }
        if (part == null) {
            throw new IllegalStateException();
        }
        part.init(parent, element, def, partParams);
        return part;
    }

    public static final class FocusReceivedEvent
    extends PartEvent {
        public FocusReceivedEvent(SapphirePart part) {
            super(part);
        }
    }

    public static final class ImageChangedEvent
    extends PartEvent {
        public ImageChangedEvent(SapphirePart part) {
            super(part);
        }
    }

    protected final class ImageManager {
        private final Function imageFunction;
        private final Function defaultValueFunction;
        private boolean initialized;
        private boolean broadcastImageEvents;
        private FunctionResult imageFunctionResult;
        private ImageData baseImageData;
        private ImageDescriptor base;
        private ImageDescriptor error;
        private ImageDescriptor warning;
        private ImageDescriptor current;

        public ImageManager(Function imageFunction) {
            this(imageFunction, (Function)Literal.NULL);
        }

        public ImageManager(Function imageFunction, Function defaultValueFunction) {
            this.imageFunction = imageFunction;
            this.defaultValueFunction = defaultValueFunction;
        }

        private void init() {
            if (!this.initialized) {
                this.initialized = true;
                this.imageFunctionResult = SapphirePart.this.initExpression(this.imageFunction, ImageData.class, this.defaultValueFunction, new Runnable(){

                    @Override
                    public void run() {
                        ImageManager.this.refresh();
                    }
                });
                SapphirePart.this.attach((Listener)new FilteredListener<PartValidationEvent>(){

                    protected void handleTypedEvent(PartValidationEvent event) {
                        ImageManager.this.refresh();
                    }
                });
                this.refresh();
                this.broadcastImageEvents = true;
            }
        }

        public ImageDescriptor getImage() {
            this.init();
            this.broadcastImageEvents = true;
            return this.current;
        }

        private void refresh() {
            ImageDescriptor old = this.current;
            if (this.imageFunctionResult != null) {
                ImageData newBaseImageData = (ImageData)this.imageFunctionResult.value();
                if (this.baseImageData != newBaseImageData) {
                    this.baseImageData = newBaseImageData;
                    this.base = SwtUtil.toImageDescriptor(this.baseImageData);
                    this.error = null;
                    this.warning = null;
                }
                if (this.base == null) {
                    this.current = null;
                } else {
                    this.current = this.base;
                    Status st = SapphirePart.this.validation();
                    Status.Severity severity = st.severity();
                    if (severity == Status.Severity.ERROR) {
                        if (this.error == null) {
                            this.error = new ProblemOverlayImageDescriptor(this.base, Status.Severity.ERROR);
                        }
                        this.current = this.error;
                    } else if (severity == Status.Severity.WARNING) {
                        if (this.warning == null) {
                            this.warning = new ProblemOverlayImageDescriptor(this.base, Status.Severity.WARNING);
                        }
                        this.current = this.warning;
                    }
                }
            }
            if (this.broadcastImageEvents && this.current != old) {
                SapphirePart.this.broadcast(new ImageChangedEvent(SapphirePart.this));
            }
        }

        public void dispose() {
            if (this.imageFunctionResult != null) {
                this.imageFunctionResult.dispose();
            }
        }
    }

    public static final class LabelChangedEvent
    extends PartEvent {
        public LabelChangedEvent(SapphirePart part) {
            super(part);
        }
    }

    public static abstract class PartEvent
    extends Event {
        private final SapphirePart part;

        public PartEvent(SapphirePart part) {
            this.part = part;
        }

        public SapphirePart part() {
            return this.part;
        }

        protected Map<String, String> fillTracingInfo(Map<String, String> info) {
            super.fillTracingInfo(info);
            Element element = this.part.getLocalModelElement();
            info.put("part", String.valueOf(this.part.getClass().getName()) + '(' + System.identityHashCode(this.part) + ')');
            info.put("element", String.valueOf(element.type().getQualifiedName()) + '(' + System.identityHashCode(element) + ')');
            return info;
        }
    }

    public static final class PartInitializationEvent
    extends PartEvent {
        public PartInitializationEvent(SapphirePart part) {
            super(part);
        }
    }
}

