/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeFactoryPart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;

public class MoveShapeUpActionHandler
extends SapphireActionHandler {
    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        ISapphirePart part = this.getPart();
        SapphireDiagramEditorPagePart editorPart = part.nearest(SapphireDiagramEditorPagePart.class);
        editorPart.attach((Listener)new FilteredListener<SapphireEditorPagePart.SelectionChangedEvent>(){

            protected void handleTypedEvent(SapphireEditorPagePart.SelectionChangedEvent event) {
                MoveShapeUpActionHandler.this.refreshEnablement();
            }
        });
        this.refreshEnablement();
    }

    private void refreshEnablement() {
        ISapphirePart part = this.getPart();
        boolean enabled = false;
        if (part instanceof ShapePart && part.parent() instanceof ShapeFactoryPart) {
            ShapeFactoryPart shapeFactory = (ShapeFactoryPart)part.parent();
            List<ShapePart> children = shapeFactory.getChildren();
            enabled = children.indexOf(part) > 0;
        }
        this.setEnabled(enabled);
    }

    @Override
    protected Object run(Presentation context) {
        ISapphirePart part = this.getPart();
        ShapeFactoryPart shapeFactory = (ShapeFactoryPart)part.parent();
        Element element = part.getLocalModelElement();
        ElementList<Element> list = shapeFactory.getModelElementList();
        list.moveUp(element);
        SapphireDiagramEditorPagePart editorPart = part.nearest(SapphireDiagramEditorPagePart.class);
        editorPart.setSelections(Collections.singletonList(part), true);
        this.refreshEnablement();
        return null;
    }
}

