/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.ListPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.internal.ColumnSortComparator;
import org.eclipse.sapphire.util.CollectionsUtil;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class CheckBoxListPropertyEditorPresentation
extends ListPropertyEditorPresentation {
    @Text(value="<empty>")
    private static LocalizableText emptyIndicator;
    private Table table;
    private CheckboxTableViewer tableViewer;
    private ElementType memberType;
    private ValueProperty memberProperty;
    private PossibleValuesService possibleValuesService;
    private Listener possibleValuesServiceListener;

    static {
        LocalizableText.init(CheckBoxListPropertyEditorPresentation.class);
    }

    public CheckBoxListPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    protected void createContents(Composite parent) {
        PropertyDef prop;
        PropertyEditorPart part = this.part();
        Property property = part.property();
        this.memberType = property.definition().getType();
        SortedSet allMemberProperties = this.memberType.properties();
        if (allMemberProperties.size() == 1) {
            prop = (PropertyDef)allMemberProperties.first();
            if (!(prop instanceof ValueProperty)) {
                throw new IllegalStateException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.memberProperty = (ValueProperty)prop;
        this.possibleValuesService = (PossibleValuesService)property.service(PossibleValuesService.class);
        this.possibleValuesServiceListener = new Listener(){

            public void handle(Event event) {
                CheckBoxListPropertyEditorPresentation.this.tableViewer.refresh();
            }
        };
        this.possibleValuesService.attach(this.possibleValuesServiceListener);
        Composite mainComposite = this.createMainComposite(parent);
        mainComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(mainComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        Composite tableComposite = new Composite(mainComposite, 0);
        tableComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)67584);
        this.table = this.tableViewer.getTable();
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 100, true));
        decorator.addEditorControl((Control)mainComposite);
        SwtUtil.suppressDashedTableEntryBorder(this.table);
        ColumnSortComparator comparator = new ColumnSortComparator(){

            @Override
            protected String convertToString(Object obj) {
                return ((Entry)obj).value;
            }
        };
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            private List<Entry> entries = new ArrayList<Entry>();

            public Object[] getElements(Object input) {
                Set possibleValues;
                if (this.entries != null) {
                    for (Entry entry : this.entries) {
                        entry.dispose();
                    }
                    this.entries = null;
                }
                HashMap<String, LinkedList<Element>> valueToElements = new HashMap<String, LinkedList<Element>>();
                for (Element element : CheckBoxListPropertyEditorPresentation.this.property()) {
                    String value = CheckBoxListPropertyEditorPresentation.this.readMemberProperty(element);
                    LinkedList<Element> elements = (LinkedList<Element>)valueToElements.get(value);
                    if (elements == null) {
                        elements = new LinkedList<Element>();
                        valueToElements.put(value, elements);
                    }
                    elements.add(element);
                }
                this.entries = new ArrayList<Entry>();
                try {
                    possibleValues = CheckBoxListPropertyEditorPresentation.this.possibleValuesService.values();
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    possibleValues = SetFactory.empty();
                }
                for (String value : possibleValues) {
                    Entry entry;
                    LinkedList elements = (LinkedList)valueToElements.get(value);
                    if (elements == null) {
                        entry = new Entry(value, null);
                    } else {
                        Element element = (Element)elements.remove();
                        if (elements.isEmpty()) {
                            valueToElements.remove(value);
                        }
                        entry = new Entry(value, element);
                    }
                    this.entries.add(entry);
                }
                for (Map.Entry entry : valueToElements.entrySet()) {
                    String value = (String)entry.getKey();
                    for (Element element : (LinkedList)entry.getValue()) {
                        this.entries.add(new Entry(value, element));
                    }
                }
                return this.entries.toArray();
            }

            public void dispose() {
                for (Entry entry : this.entries) {
                    entry.dispose();
                }
                this.entries = null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Entry)element).label();
            }

            public Image getImage(Object element) {
                return ((Entry)element).image();
            }

            public Color getForeground(Object element) {
                return ((Entry)element).foreground();
            }
        };
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        ICheckStateProvider checkStateProvider = new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((Entry)element).selected();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        };
        this.tableViewer.setCheckStateProvider(checkStateProvider);
        if (part.getRenderingHint("show.header", true)) {
            this.table.setHeaderVisible(true);
            SwtUtil.makeTableSortable((TableViewer)this.tableViewer, Collections.singletonMap(column, comparator), this.possibleValuesService.ordered() ? null : column);
        }
        final ListSelectionService selectionService = part.service(ListSelectionService.class);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.select(CheckBoxListPropertyEditorPresentation.this.getSelectedElements());
            }
        });
        final Listener selectionServiceListener = new Listener(){

            public void handle(Event event) {
                CheckBoxListPropertyEditorPresentation.this.setSelectedElements(((ListSelectionService.ListSelectionChangedEvent)event).after());
            }
        };
        selectionService.attach(selectionServiceListener);
        this.addOnDisposeOperation(new Runnable(){

            @Override
            public void run() {
                selectionService.detach(selectionServiceListener);
                if (CheckBoxListPropertyEditorPresentation.this.possibleValuesService != null) {
                    CheckBoxListPropertyEditorPresentation.this.possibleValuesService.detach(CheckBoxListPropertyEditorPresentation.this.possibleValuesServiceListener);
                }
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Entry entry = (Entry)event.getElement();
                entry.flip();
                selectionService.select(CheckBoxListPropertyEditorPresentation.this.getSelectedElements());
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Entry entry = null;
                TableItem[] tableItemArray = CheckBoxListPropertyEditorPresentation.this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getBounds().contains(event.x, event.y)) {
                        entry = (Entry)item.getData();
                        break;
                    }
                    ++n2;
                }
                if (entry != null) {
                    entry.flip();
                    selectionService.select(CheckBoxListPropertyEditorPresentation.this.getSelectedElements());
                }
            }
        });
        this.tableViewer.setInput(new Object());
        this.addControl((Control)this.table);
    }

    @Override
    protected boolean canScaleVertically() {
        return true;
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.table.setFocus();
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.refreshTable();
    }

    @Override
    protected void handleChildPropertyEvent(PropertyContentEvent event) {
        super.handleChildPropertyEvent(event);
        this.refreshTable();
    }

    public final Element getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        if (sel == null) {
            return null;
        }
        return ((Entry)sel.getFirstElement()).element;
    }

    public final List<Element> getSelectedElements() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        ListFactory elements = ListFactory.start();
        if (sel != null) {
            Iterator itr = sel.iterator();
            while (itr.hasNext()) {
                Element element = ((Entry)itr.next()).element;
                if (element == null) continue;
                elements.add((Object)element);
            }
        }
        return elements.result();
    }

    public final void setSelectedElements(List<Element> elements) {
        if (!CollectionsUtil.equalsBasedOnEntryIdentity(this.getSelectedElements(), elements)) {
            ListFactory entries = ListFactory.start();
            for (Element element : elements) {
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Entry entry = (Entry)item.getData();
                    if (entry.element == element) {
                        entries.add((Object)entry);
                    }
                    ++n2;
                }
            }
            this.tableViewer.setSelection((ISelection)new StructuredSelection(entries.result()));
        }
    }

    private void refreshTable() {
        int oldItemCount = this.table.getItemCount();
        Entry oldSelection = (Entry)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        this.tableViewer.refresh();
        int newItemCount = this.table.getItemCount();
        if (oldSelection != null) {
            String oldSelectionValue = oldSelection.value;
            Entry newSelection = null;
            int i = 0;
            while (i < newItemCount && newSelection == null) {
                Entry entry = (Entry)this.table.getItem(i).getData();
                if (oldSelectionValue.equals(entry.value)) {
                    newSelection = entry;
                }
                ++i;
            }
            if (newSelection != null) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(newSelection));
            }
        }
        if (oldItemCount != newItemCount) {
            this.table.getParent().layout(true, true);
        }
    }

    private ElementType getMemberType() {
        return this.memberType;
    }

    private ValueProperty getMemberProperty() {
        return this.memberProperty;
    }

    private String readMemberProperty(Element element) {
        String text = element.property(this.memberProperty).text();
        return text == null ? "" : text;
    }

    public final class Entry {
        private final LocalizationService localizationService;
        private String value;
        private Element element;
        private Value<?> property;
        private ValueLabelService valueLabelService;
        private ValueImageService valueImageService;
        private ImageService elementImageService;
        private Listener elementImageServiceListener;
        private Listener propertyValidationListener;

        public Entry(String value, Element element) {
            this.localizationService = (LocalizationService)CheckBoxListPropertyEditorPresentation.this.part().definition().adapt(LocalizationService.class);
            this.value = value;
            this.valueLabelService = (ValueLabelService)CheckBoxListPropertyEditorPresentation.this.memberProperty.service(ValueLabelService.class);
            this.valueImageService = (ValueImageService)CheckBoxListPropertyEditorPresentation.this.memberProperty.service(ValueImageService.class);
            this.rebase(element);
        }

        private void rebase(Element element) {
            if (this.element != null) {
                if (this.elementImageService != null) {
                    this.elementImageService.detach(this.elementImageServiceListener);
                }
                if (this.elementImageService != null || this.valueImageService != null) {
                    this.property.detach(this.propertyValidationListener);
                }
            }
            this.element = element;
            if (this.element != null) {
                this.property = this.element.property(CheckBoxListPropertyEditorPresentation.this.getMemberProperty());
                this.elementImageService = (ImageService)this.element.service(ImageService.class);
                if (this.elementImageService != null) {
                    if (this.elementImageServiceListener == null) {
                        this.elementImageServiceListener = new Listener(){

                            public void handle(Event event) {
                                CheckBoxListPropertyEditorPresentation.this.tableViewer.update((Object)Entry.this, null);
                            }
                        };
                    }
                    this.elementImageService.attach(this.elementImageServiceListener);
                }
                if (this.elementImageService != null || this.valueImageService != null) {
                    if (this.propertyValidationListener == null) {
                        this.propertyValidationListener = new FilteredListener<PropertyValidationEvent>(){

                            protected void handleTypedEvent(PropertyValidationEvent event) {
                                CheckBoxListPropertyEditorPresentation.this.tableViewer.update((Object)Entry.this, null);
                            }
                        };
                    }
                    this.property.attach(this.propertyValidationListener);
                }
            } else {
                this.property = null;
            }
        }

        public String label() {
            String label = null;
            if (this.value.length() == 0) {
                label = emptyIndicator.text();
            } else {
                try {
                    label = this.valueLabelService.provide(this.value);
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
                if (label == null) {
                    label = this.value;
                } else if (!label.equals(this.value)) {
                    label = this.localizationService.transform(label, CapitalizationType.FIRST_WORD_ONLY, false);
                }
            }
            return label;
        }

        public Image image() {
            ImageData image = null;
            if (this.elementImageService != null) {
                image = this.elementImageService.image();
            } else {
                try {
                    image = this.valueImageService.provide(this.value);
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
                if (image == null) {
                    image = CheckBoxListPropertyEditorPresentation.this.getMemberType().image();
                }
            }
            if (this.property == null) {
                return CheckBoxListPropertyEditorPresentation.this.resources().image(image);
            }
            return CheckBoxListPropertyEditorPresentation.this.resources().image(image, this.property.validation().severity());
        }

        public Color foreground() {
            Color color = null;
            if (this.value.length() == 0) {
                color = Display.getCurrent().getSystemColor(16);
            }
            return color;
        }

        public boolean selected() {
            return this.element != null;
        }

        public void flip() {
            if (this.element == null) {
                this.rebase(CheckBoxListPropertyEditorPresentation.this.property().insert());
                this.property.write((Object)this.value);
            } else {
                Element el = this.element;
                this.rebase(null);
                CheckBoxListPropertyEditorPresentation.this.property().remove((Object)el);
            }
        }

        public void dispose() {
            this.rebase(null);
        }
    }

    public static final class EnumFactory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            PropertyDef memberProperty;
            SortedSet properties;
            Property property = part.property();
            if (property.definition() instanceof ListProperty && ((PossibleTypesService)property.service(PossibleTypesService.class)).types().size() == 1 && (properties = property.definition().getType().properties()).size() == 1 && (memberProperty = (PropertyDef)properties.first()) instanceof ValueProperty && memberProperty.hasAnnotation(NoDuplicates.class) && Enum.class.isAssignableFrom(memberProperty.getTypeClass())) {
                return new CheckBoxListPropertyEditorPresentation(part, parent, composite);
            }
            return null;
        }
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            return new CheckBoxListPropertyEditorPresentation(part, parent, composite);
        }
    }
}

