/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public final class ElementsTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "Sapphire.Elements";
    private static final int TYPE_ID = ElementsTransfer.registerType((String)"Sapphire.Elements");
    private final ClassLoader classLoader;

    public ElementsTransfer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        List elements = (List)data;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
            this.javaToNative(elements, out);
            out.close();
            byteArrayOutputStream.close();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    private void javaToNative(List<Element> elements, DataOutputStream out) throws IOException {
        out.writeInt(elements.size());
        for (Element element : elements) {
            this.javaToNative(element, out);
        }
    }

    private void javaToNative(Element element, DataOutputStream out) throws IOException {
        out.writeUTF(element.type().getQualifiedName());
        for (Property property : element.properties()) {
            ElementList list;
            if (property.definition().isReadOnly()) continue;
            if (property instanceof Value) {
                String value = ((Value)property).text(false);
                if (value == null) continue;
                out.writeByte(1);
                out.writeUTF(property.name());
                out.writeUTF(value);
                continue;
            }
            if (property instanceof ElementHandle) {
                Element child = ((ElementHandle)property).content();
                if (child == null) continue;
                out.writeByte(1);
                out.writeUTF(property.name());
                this.javaToNative(child, out);
                continue;
            }
            if (!(property.definition() instanceof ListProperty) || (list = element.property((ListProperty)property.definition())).isEmpty()) continue;
            out.writeByte(1);
            out.writeUTF(property.name());
            this.javaToNative((List<Element>)list, out);
        }
        out.writeByte(0);
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            ListFactory elementsListFactory = ListFactory.start();
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                String qualifiedTypeName = in.readUTF();
                ElementType type = ElementType.read((ClassLoader)this.classLoader, (String)qualifiedTypeName);
                Element element = type.instantiate();
                this.nativeToJava(in, element);
                elementsListFactory.add((Object)element);
                ++i;
            }
            return elementsListFactory.result();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void nativeToJava(DataInputStream in, Element element) throws IOException {
        while (in.readByte() != 0) {
            String propertyName = in.readUTF();
            Property property = element.property(propertyName);
            if (property == null) continue;
            if (property instanceof Value) {
                String value = in.readUTF();
                ((Value)property).write((Object)value);
                continue;
            }
            if (property instanceof ElementHandle) {
                String qualifiedTypeName = in.readUTF();
                ElementType type = ElementType.read((ClassLoader)this.classLoader, (String)qualifiedTypeName);
                Element child = ((ElementHandle)property).content(true, type);
                this.nativeToJava(in, child);
                continue;
            }
            if (!(property instanceof ElementList)) continue;
            ElementList list = (ElementList)property;
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                String qualifiedTypeName = in.readUTF();
                ElementType type = ElementType.read((ClassLoader)this.classLoader, (String)qualifiedTypeName);
                Element child = list.insert(type);
                this.nativeToJava(in, child);
                ++i;
            }
        }
    }
}

