/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.ValueLabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public final class PossibleValuesBrowseActionHandler
extends BrowseActionHandler {
    public static final String ID = "Sapphire.Browse.Possible";

    public PossibleValuesBrowseActionHandler() {
        this.setId(ID);
    }

    @Override
    protected String browse(Presentation context) {
        ValueProperty property = this.property().definition();
        PossibleValuesService possibleValuesService = (PossibleValuesService)this.property().service(PossibleValuesService.class);
        if (possibleValuesService != null) {
            Set valuesList = possibleValuesService.values();
            Object[] valuesArray = valuesList.toArray(new String[valuesList.size()]);
            ValueLabelProvider labelProvider = new ValueLabelProvider((PropertyEditorPart)this.getPart(), property);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(((FormComponentPresentation)context).shell(), (ILabelProvider)labelProvider);
            dialog.setElements(valuesArray);
            dialog.setIgnoreCase(!possibleValuesService.isCaseSensitive());
            dialog.setMultipleSelection(false);
            dialog.setHelpAvailable(false);
            dialog.setTitle(property.getLabel(false, CapitalizationType.TITLE_STYLE, false));
            dialog.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length == 1) {
                return (String)result[0];
            }
        }
        return null;
    }
}

