/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.form;

import com.liferay.ide.ui.form.FormLayoutFactory;
import com.liferay.ide.ui.form.IDEFormPage;
import com.liferay.ide.ui.form.IDESection;
import com.liferay.ide.ui.form.StructuredViewerPart;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerSection
extends IDESection {
    protected StructuredViewerPart fViewerPart;
    private boolean fDoSelection;

    public StructuredViewerSection(IDEFormPage formPage, Composite parent, int style, String[] buttonLabels) {
        this(formPage, parent, style, true, buttonLabels);
    }

    public StructuredViewerSection(IDEFormPage formPage, Composite parent, int style, boolean titleBar, String[] buttonLabels) {
        super(formPage, parent, style, titleBar);
        this.fViewerPart = this.createViewerPart(buttonLabels);
        this.fViewerPart.setMinimumSize(50, 50);
        FormToolkit toolkit = formPage.getManagedForm().getToolkit();
        this.createClient(this.getSection(), toolkit);
        this.fDoSelection = true;
    }

    protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.fViewerPart.createControl(parent, style, span, toolkit);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                StructuredViewerSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.fViewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, span));
        return container;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void buttonSelected(int index) {
    }

    protected void doPaste() {
    }

    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    protected ISelection getViewerSelection() {
        return this.fViewerPart.getViewer().getSelection();
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return false;
    }

    public void setFocus() {
        this.fViewerPart.getControl().setFocus();
    }

    public StructuredViewerPart getStructuredViewerPart() {
        return this.fViewerPart;
    }

    protected int getNewSelectionIndex(int thisIndex, int length) {
        if (thisIndex == length - 1) {
            return thisIndex - 1;
        }
        return thisIndex + 1;
    }

    protected int getArrayIndex(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean isDragAndDropEnabled() {
        return false;
    }

    protected void doSelect(boolean select) {
        this.fDoSelection = select;
    }

    protected boolean canSelect() {
        return this.fDoSelection;
    }
}

