/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.service.xml.Unmarshaller;
import org.eclipse.epp.internal.mpc.core.util.ITransport;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteMarketplaceService<T> {
    protected URL baseUrl;
    public static final String API_URI_SUFFIX = "api/p";
    protected static final String UTF_8 = "UTF-8";
    private final ITransport transport = TransportFactory.instance().getTransport();
    private Map<String, String> requestMetaParameters;

    protected IStatus createErrorStatus(String message, Throwable t) {
        return new Status(4, "org.eclipse.epp.mpc.core", 0, message, t);
    }

    private void checkConfiguration() {
        if (this.baseUrl == null) {
            throw new IllegalStateException(Messages.DefaultMarketplaceService_mustConfigureBaseUrl);
        }
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected T processRequest(String relativeUrl, IProgressMonitor monitor) throws CoreException {
        return this.processRequest(relativeUrl, true, monitor);
    }

    protected T processRequest(String relativeUrl, boolean withMetaParams, IProgressMonitor monitor) throws CoreException {
        URI baseUri;
        try {
            baseUri = this.baseUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return this.processRequest(baseUri.toString(), relativeUrl, withMetaParams, monitor);
    }

    protected T processRequest(String baseUri, String relativePath, IProgressMonitor monitor) throws CoreException {
        return this.processRequest(baseUri, relativePath, true, monitor);
    }

    protected T processRequest(String baseUri, String relativePath, boolean withMetaParams, IProgressMonitor monitor) throws CoreException {
        URI location;
        this.checkConfiguration();
        if (baseUri == null || relativePath == null) {
            throw new IllegalArgumentException();
        }
        String uri = baseUri;
        if (!uri.endsWith("/") && !relativePath.startsWith("/")) {
            uri = String.valueOf(uri) + '/';
        }
        uri = String.valueOf(uri) + relativePath;
        if (withMetaParams) {
            uri = this.addMetaParameters(uri);
        }
        try {
            location = new URI(uri);
        }
        catch (URISyntaxException e) {
            String message = NLS.bind((String)Messages.DefaultMarketplaceService_invalidLocation, (Object)uri);
            throw new CoreException(this.createErrorStatus(message, e));
        }
        Unmarshaller unmarshaller = new Unmarshaller();
        monitor.beginTask(NLS.bind((String)Messages.DefaultMarketplaceService_retrievingDataFrom, (Object)baseUri), 100);
        try {
            try {
                XMLReader xmlReader;
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setNamespaceAware(true);
                try {
                    xmlReader = parserFactory.newSAXParser().getXMLReader();
                }
                catch (Exception e1) {
                    throw new IllegalStateException(e1);
                }
                xmlReader.setContentHandler(unmarshaller);
                InputStream in = this.transport.stream(location, monitor);
                try {
                    monitor.worked(30);
                    InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), UTF_8);
                    try {
                        xmlReader.parse(new InputSource(reader));
                    }
                    catch (SAXException e) {
                        MarketplaceClientCore.error(NLS.bind((String)Messages.DefaultMarketplaceService_parseError, (Object)location.toString()), e);
                        throw new IOException(e.getMessage());
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof OperationCanceledException) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                String message = NLS.bind((String)Messages.DefaultMarketplaceService_cannotCompleteRequest_reason, (Object)location.toString(), (Object)e.getMessage());
                throw new CoreException(this.createErrorStatus(message, e));
            }
        }
        finally {
            monitor.done();
        }
        Object model = unmarshaller.getModel();
        if (model == null) {
            throw new IllegalStateException();
        }
        try {
            return (T)model;
        }
        catch (Exception exception) {
            String message = NLS.bind((String)Messages.DefaultMarketplaceService_unexpectedResponseContent, (Object)model.getClass().getSimpleName());
            throw new CoreException(this.createErrorStatus(message, null));
        }
    }

    public String addMetaParameters(String uri) {
        if (this.requestMetaParameters != null) {
            try {
                boolean hasQueryString = uri.indexOf(63) != -1;
                for (Map.Entry<String, String> param : this.requestMetaParameters.entrySet()) {
                    if (param.getKey() == null) continue;
                    if (hasQueryString) {
                        uri = String.valueOf(uri) + '&';
                    } else {
                        hasQueryString = true;
                        uri = String.valueOf(uri) + '?';
                    }
                    uri = String.valueOf(uri) + URLEncoder.encode(param.getKey(), UTF_8);
                    uri = String.valueOf(uri) + '=';
                    if (param.getValue() == null) continue;
                    uri = String.valueOf(uri) + URLEncoder.encode(param.getValue(), UTF_8);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return uri;
    }

    public Map<String, String> getRequestMetaParameters() {
        return this.requestMetaParameters;
    }

    public void setRequestMetaParameters(Map<String, String> requestMetaParameters) {
        this.requestMetaParameters = requestMetaParameters;
    }
}

