/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.internal;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.internal.DiagramComboBoxCellEditor;
import org.eclipse.sapphire.ui.swt.gef.parts.NodeDirectEditManager;
import org.eclipse.swt.widgets.Composite;

public class ComboBoxDirectEditorManager
extends NodeDirectEditManager {
    private ComboBoxCellEditor comboCellEditor;
    private ICellEditorListener cellEditorListener;
    private boolean committing = false;
    private String initialValue;

    public ComboBoxDirectEditorManager(GraphicalEditPart source, TextPart textPart, CellEditorLocator locator, Label label) {
        super(source, textPart, locator, label);
        this.initCellEditorListener();
    }

    @Override
    protected CellEditor createCellEditorOn(Composite composite) {
        this.comboCellEditor = new DiagramComboBoxCellEditor(this.getTextPart(), composite, (Property)this.property);
        return this.comboCellEditor;
    }

    @Override
    protected void initCellEditor() {
        String initValue = this.property.text();
        if (initValue == null) {
            initValue = this.textPart.getContent();
        }
        this.initialValue = initValue;
        PossibleValuesService possibleValuesService = (PossibleValuesService)this.property.service(PossibleValuesService.class);
        Set possibleValues = possibleValuesService.values();
        Iterator it = possibleValues.iterator();
        int index = -1;
        while (it.hasNext()) {
            ++index;
            if (((String)it.next()).equals(initValue)) break;
        }
        this.getCellEditor().setValue((Object)index);
        this.initCellEditorPresentation();
        this.comboCellEditor.addListener(this.cellEditorListener);
    }

    protected void unhookListeners() {
        this.comboCellEditor.removeListener(this.cellEditorListener);
        super.unhookListeners();
    }

    protected void commit() {
    }

    private void initCellEditorListener() {
        this.cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                ComboBoxDirectEditorManager.this.applyEditorValue();
            }
        };
    }

    private void applyEditorValue() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.eraseFeedback();
            String newValue = (String)this.comboCellEditor.getValue();
            if (newValue != null && !newValue.equals(this.initialValue)) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                stack.execute(this.getEditPart().getCommand((Request)this.getDirectEditRequest()));
            }
        }
        finally {
            this.bringDown();
            this.committing = false;
        }
    }
}

