/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.tasks.ui.ITaskAttachmentViewer;
import org.eclipse.mylyn.internal.tasks.ui.TaskAttachmentBrowserViewer;
import org.eclipse.mylyn.internal.tasks.ui.TaskAttachmentEditorViewer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class TaskAttachmentViewerManager {
    public ITaskAttachmentViewer getBrowserViewer(ITaskAttachment attachment) {
        if (attachment.getUrl() != null && attachment.getUrl().trim().length() > 0) {
            return new TaskAttachmentBrowserViewer();
        }
        return null;
    }

    public List<ITaskAttachmentViewer> getWorkbenchViewers(ITaskAttachment attachment) {
        IEditorDescriptor[] descriptors;
        IEditorDescriptor defaultTextEditor;
        ArrayList<ITaskAttachmentViewer> result = new ArrayList<ITaskAttachmentViewer>();
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor defaultEditor = registry.getDefaultEditor(AttachmentUtil.getAttachmentFilename(attachment));
        if (defaultEditor != null) {
            result.add(new TaskAttachmentEditorViewer(defaultEditor));
        }
        if (!((defaultTextEditor = registry.findEditor("org.eclipse.ui.DefaultTextEditor")) == null || defaultEditor != null && defaultTextEditor.getId().equals(defaultEditor.getId()))) {
            result.add(new TaskAttachmentEditorViewer(defaultTextEditor));
        }
        IEditorDescriptor[] iEditorDescriptorArray = descriptors = registry.getEditors(AttachmentUtil.getAttachmentFilename(attachment));
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor ied = iEditorDescriptorArray[n2];
            if (defaultEditor == null || !ied.getId().equals(defaultEditor.getId())) {
                result.add(new TaskAttachmentEditorViewer(ied));
            }
            ++n2;
        }
        return result;
    }

    public List<ITaskAttachmentViewer> getSystemViewers(ITaskAttachment attachment) {
        ArrayList<ITaskAttachmentViewer> result = new ArrayList<ITaskAttachmentViewer>();
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor extern = registry.findEditor("org.eclipse.ui.systemExternalEditor");
        result.add(new TaskAttachmentEditorViewer(extern));
        if (registry.isSystemInPlaceEditorAvailable(AttachmentUtil.getAttachmentFilename(attachment))) {
            IEditorDescriptor inplace = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
            result.add(new TaskAttachmentEditorViewer(inplace));
        }
        return result;
    }

    public List<ITaskAttachmentViewer> getTaskAttachmentViewers(ITaskAttachment attachment) {
        ArrayList<ITaskAttachmentViewer> result = new ArrayList<ITaskAttachmentViewer>();
        ITaskAttachmentViewer browserViewer = this.getBrowserViewer(attachment);
        if (browserViewer != null) {
            result.add(browserViewer);
        }
        result.addAll(this.getWorkbenchViewers(attachment));
        result.addAll(this.getSystemViewers(attachment));
        return result;
    }

    public ITaskAttachmentViewer getPreferredViewer(ITaskAttachment attachment) {
        List<ITaskAttachmentViewer> viewers = this.getTaskAttachmentViewers(attachment);
        String preferred = this.getPreferredViewerID(attachment);
        if (preferred != null) {
            int i = 0;
            while (i < viewers.size()) {
                if (preferred.equals(viewers.get(i).getId())) {
                    return viewers.get(i);
                }
                ++i;
            }
        }
        if (viewers.isEmpty()) {
            return null;
        }
        return viewers.get(0);
    }

    public String getPreferredViewerID(ITaskAttachment attachment) {
        String ext = this.getExtension(attachment);
        if (ext == null) {
            return null;
        }
        return this.getPreferencesStore().getString("org.eclipse.mylyn.tasks.ui.attachments.preferredViewerID_" + ext);
    }

    private IPreferenceStore getPreferencesStore() {
        return TasksUiPlugin.getDefault().getPreferenceStore();
    }

    public void savePreferredViewerID(ITaskAttachment attachment, String handlerID) {
        String ext = this.getExtension(attachment);
        if (ext == null) {
            return;
        }
        this.getPreferencesStore().putValue("org.eclipse.mylyn.tasks.ui.attachments.preferredViewerID_" + ext, handlerID);
    }

    private String getExtension(ITaskAttachment attachment) {
        if (attachment == null) {
            return null;
        }
        String fname = AttachmentUtil.getAttachmentFilename(attachment);
        int dot = fname.lastIndexOf(46);
        if (dot < 0) {
            return null;
        }
        return fname.substring(dot + 1);
    }
}

