/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMenu
extends Action
implements IMenuCreator {
    List<PDELauncherFormEditor.LauncherAction> fActions = new LinkedList<PDELauncherFormEditor.LauncherAction>();
    Menu fMenu;

    public ActionMenu(PDELauncherFormEditor.LauncherAction[] actions) {
        int i = 0;
        while (i < actions.length) {
            this.fActions.add(actions[i]);
            ++i;
        }
        if (!this.fActions.isEmpty()) {
            this.setToolTipText(this.fActions.get(0).getToolTipText());
            this.setImageDescriptor(this.fActions.get(0).getImageDescriptor());
            if (this.fActions.size() > 1) {
                this.setMenuCreator(this);
            }
        }
    }

    public void run() {
        if (!this.fActions.isEmpty()) {
            this.fActions.get(0).run();
        }
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        Iterator<PDELauncherFormEditor.LauncherAction> iterator = this.fActions.iterator();
        while (iterator.hasNext()) {
            ActionContributionItem item = new ActionContributionItem((IAction)iterator.next());
            item.fill(this.fMenu, -1);
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void updateActionOrder(final List<String> orderedLauncherIds) {
        if (!this.fActions.isEmpty()) {
            Collections.sort(this.fActions, new Comparator<PDELauncherFormEditor.LauncherAction>(){

                @Override
                public int compare(PDELauncherFormEditor.LauncherAction o1, PDELauncherFormEditor.LauncherAction o2) {
                    String id1 = o1.getConfigurationElement().getAttribute("id");
                    String id2 = o2.getConfigurationElement().getAttribute("id");
                    int index1 = orderedLauncherIds.indexOf(id1);
                    int index2 = orderedLauncherIds.indexOf(id2);
                    if (index1 == -1 && index2 == -1) {
                        return 0;
                    }
                    if (index1 == -1) {
                        return 1;
                    }
                    if (index2 == -1) {
                        return -1;
                    }
                    if (index1 <= index2) {
                        return -1;
                    }
                    return 1;
                }
            });
            this.setToolTipText(this.fActions.get(0).getToolTipText());
            this.setImageDescriptor(this.fActions.get(0).getImageDescriptor());
        }
    }
}

