/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.category.CategoryLabelProvider;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;

public class CategoryOutlinePage
extends FormOutlinePage {
    private LabelProvider fLabelProvider;

    public CategoryOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    protected Object[] getChildren(Object parent) {
        ISiteCategoryDefinition catDef;
        ISite site;
        PDEFormPage page;
        ISiteModel model;
        if (parent instanceof PDEFormPage && (model = (ISiteModel)(page = (PDEFormPage)((Object)parent)).getModel()).isValid()) {
            site = model.getSite();
            if (page.getId().equals("ius")) {
                ArrayList<Object> result = new ArrayList<Object>();
                ISiteCategoryDefinition[] catDefs = site.getCategoryDefinitions();
                int i = 0;
                while (i < catDefs.length) {
                    result.add(catDefs[i]);
                    ++i;
                }
                ISiteFeature[] features = site.getFeatures();
                int i2 = 0;
                while (i2 < features.length) {
                    if (features[i2].getCategories().length == 0) {
                        result.add(new SiteFeatureAdapter(null, features[i2]));
                    }
                    ++i2;
                }
                ISiteBundle[] bundles = site.getBundles();
                int i3 = 0;
                while (i3 < bundles.length) {
                    if (bundles[i3].getCategories().length == 0) {
                        result.add(new SiteBundleAdapter(null, bundles[i3]));
                    }
                    ++i3;
                }
                return result.toArray();
            }
        }
        if (parent instanceof ISiteCategoryDefinition && (model = (catDef = (ISiteCategoryDefinition)parent).getModel()).isValid()) {
            site = model.getSite();
            ISiteFeature[] features = site.getFeatures();
            HashSet<Serializable> result = new HashSet<Serializable>();
            int i = 0;
            while (i < features.length) {
                ISiteCategory[] cats = features[i].getCategories();
                int j = 0;
                while (j < cats.length) {
                    if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                        result.add(new SiteFeatureAdapter(cats[j].getName(), features[i]));
                    }
                    ++j;
                }
                ++i;
            }
            ISiteBundle[] bundles = site.getBundles();
            int i4 = 0;
            while (i4 < bundles.length) {
                ISiteCategory[] cats = bundles[i4].getCategories();
                int j = 0;
                while (j < cats.length) {
                    if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                        result.add(new SiteBundleAdapter(cats[j].getName(), bundles[i4]));
                    }
                    ++j;
                }
                ++i4;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    protected String getParentPageId(Object item) {
        String pageId = null;
        if (item instanceof ISiteCategoryDefinition || item instanceof SiteFeatureAdapter || item instanceof SiteBundleAdapter) {
            pageId = "ius";
        }
        if (pageId != null) {
            return pageId;
        }
        return super.getParentPageId(item);
    }

    public ILabelProvider createLabelProvider() {
        this.fLabelProvider = new CategoryLabelProvider();
        return this.fLabelProvider;
    }

    public void dispose() {
        super.dispose();
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
    }
}

