/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

class ItemButtonController {
    private final DiscoveryItem item;
    private final Button button;
    private ButtonState buttonState;
    private final Button secondaryButton;
    private ButtonState secondaryButtonState;
    private final MarketplaceViewer viewer;

    public ItemButtonController(MarketplaceViewer marketplaceViewer, DiscoveryItem discoveryItem, Button button, Button secondaryButton) {
        this.item = discoveryItem;
        this.button = button;
        this.viewer = marketplaceViewer;
        this.secondaryButton = secondaryButton;
        this.updateButtonState();
        this.updateAppearance();
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ItemButtonController.this.buttonClicked(ItemButtonController.this.buttonState, ItemButtonController.this.secondaryButtonState);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (secondaryButton != null) {
            secondaryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ItemButtonController.this.buttonClicked(ItemButtonController.this.secondaryButtonState, ItemButtonController.this.buttonState);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
    }

    private void buttonClicked(ButtonState primary, ButtonState secondary) {
        if (primary != ButtonState.DISABLED) {
            primary = primary.nextState();
            secondary = secondary.noActionState();
            this.item.maybeModifySelection(primary.operation);
        }
        this.refresh();
    }

    private void updateButtonState() {
        this.buttonState = ButtonState.DISABLED;
        this.secondaryButtonState = ButtonState.DISABLED;
        MarketplaceNodeCatalogItem catalogItem = (MarketplaceNodeCatalogItem)((Object)this.item.getData());
        if (catalogItem.getInstallableUnits().isEmpty()) {
            this.buttonState = ButtonState.DISABLED;
            this.secondaryButtonState = ButtonState.DISABLED;
        } else {
            Operation operation = this.item.getOperation();
            boolean installed = this.isItemInstalled();
            if (installed) {
                switch (operation) {
                    case CHECK_FOR_UPDATES: {
                        this.buttonState = ButtonState.UPDATE_PENDING;
                        this.secondaryButtonState = ButtonState.UNINSTALL;
                        break;
                    }
                    case UNINSTALL: {
                        this.buttonState = ButtonState.UPDATE;
                        this.secondaryButtonState = ButtonState.UNINSTALL_PENDING;
                        break;
                    }
                    case NONE: {
                        this.buttonState = ButtonState.UPDATE;
                        this.secondaryButtonState = ButtonState.UNINSTALL;
                    }
                }
                if (this.buttonState == ButtonState.UPDATE && catalogItem.getUpdateAvailable() != null && !catalogItem.getUpdateAvailable().booleanValue()) {
                    this.buttonState = ButtonState.UPDATE_DISABLED;
                }
            } else {
                switch (operation) {
                    case INSTALL: {
                        this.buttonState = ButtonState.INSTALL_PENDING;
                        break;
                    }
                    case NONE: {
                        this.buttonState = ButtonState.INSTALL;
                    }
                }
                this.secondaryButtonState = ButtonState.DISABLED;
                if (!this.isItemAvailable()) {
                    this.buttonState = ButtonState.DISABLED;
                }
            }
        }
    }

    private boolean isItemInstalled() {
        return ((CatalogItem)this.item.getData()).isInstalled();
    }

    private boolean isItemAvailable() {
        Boolean available = ((CatalogItem)this.item.getData()).getAvailable();
        return available == null || available != false;
    }

    private void updateAppearance() {
        this.button.setText(this.buttonState.label);
        this.button.setEnabled(!this.buttonState.disabled);
        if (this.secondaryButton != null) {
            this.secondaryButton.setText(this.secondaryButtonState.label);
            this.secondaryButton.setEnabled(!this.secondaryButtonState.disabled);
        }
        this.item.layout(true, true);
    }

    public void refresh() {
        this.updateButtonState();
        this.updateAppearance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ButtonState {
        INSTALL(Messages.ItemButtonController_install, Operation.NONE, false),
        UNINSTALL(Messages.ItemButtonController_uninstall, Operation.NONE, false),
        INSTALL_PENDING(Messages.ItemButtonController_installPending, Operation.INSTALL, false),
        UNINSTALL_PENDING(Messages.ItemButtonController_uninstallPending, Operation.UNINSTALL, false),
        DISABLED(Messages.ItemButtonController_install, Operation.NONE, true),
        UPDATE_DISABLED(Messages.ItemButtonController_update, Operation.NONE, true),
        UPDATE(Messages.ItemButtonController_update, Operation.NONE, false),
        UPDATE_PENDING(Messages.ItemButtonController_updatePending, Operation.CHECK_FOR_UPDATES, false);

        final String label;
        private final Operation operation;
        private final boolean disabled;

        private ButtonState(String label, Operation operation, boolean disabled) {
            this.label = label;
            this.operation = operation;
            this.disabled = disabled;
        }

        public ButtonState nextState() {
            switch (this) {
                case INSTALL: {
                    return INSTALL_PENDING;
                }
                case INSTALL_PENDING: {
                    return INSTALL;
                }
                case UNINSTALL: {
                    return UNINSTALL_PENDING;
                }
                case UNINSTALL_PENDING: {
                    return UNINSTALL;
                }
                case UPDATE: {
                    return UPDATE_PENDING;
                }
                case UPDATE_PENDING: {
                    return UPDATE;
                }
            }
            return this;
        }

        public ButtonState noActionState() {
            switch (this) {
                case INSTALL_PENDING: {
                    return INSTALL;
                }
                case UNINSTALL_PENDING: {
                    return UNINSTALL;
                }
                case UPDATE_PENDING: {
                    return UPDATE;
                }
            }
            return this;
        }
    }
}

