/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.core.model;

import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeMapping;

public class SystemFileTransferModeMapping
implements ISystemFileTransferModeMapping,
Cloneable {
    public static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;
    private String name;
    private String extension;
    private int fileType = 0;
    private int priority = Integer.MAX_VALUE;

    public SystemFileTransferModeMapping(String extension) {
        this("*", extension);
    }

    public SystemFileTransferModeMapping(String name, String extension) {
        if (name == null || name.length() < 1) {
            this.setName("*");
        } else {
            this.setName(name);
        }
        this.setExtension(extension);
    }

    public String getExtension() {
        return this.extension;
    }

    public String getLabel() {
        if (this.extension != null) {
            return String.valueOf(this.name) + "." + this.extension;
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBinary() {
        return this.fileType == 0;
    }

    public boolean isXML() {
        return this.fileType == 2;
    }

    public boolean isText() {
        return this.fileType == 1;
    }

    public void setAsBinary() {
        this.fileType = 0;
    }

    public void setAsXML() {
        this.fileType = 2;
    }

    public void setAsText() {
        this.fileType = 1;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

