/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.lib.Repository;

public class CompareCoreUtils {
    public static String getResourceEncoding(Repository db, String repoPath) {
        if (db.isBare()) {
            return null;
        }
        IFile resource = ResourceUtil.getFileForLocation(db, repoPath);
        if (resource == null) {
            return null;
        }
        return CompareCoreUtils.getResourceEncoding((IResource)resource);
    }

    public static String getResourceEncoding(IResource resource) {
        String charset;
        IEncodedStorage encodedStorage = (IEncodedStorage)resource;
        try {
            charset = encodedStorage.getCharset();
            if (charset == null) {
                charset = resource.getParent().getDefaultCharset();
            }
        }
        catch (CoreException coreException) {
            charset = "UTF-8";
        }
        return charset;
    }
}

