/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards.registries;

import java.util.Arrays;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardSelectionPage;
import org.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardSelectionTreeElement;
import org.eclipse.rse.ui.wizards.registries.IRSEWizardCategory;
import org.eclipse.rse.ui.wizards.registries.IRSEWizardDescriptor;
import org.eclipse.rse.ui.wizards.registries.RSEWizardSelectionTreeElement;
import org.eclipse.ui.dialogs.PatternFilter;

public class RSEWizardSelectionTreePatternFilter
extends PatternFilter {
    private final WizardPage parentPage;

    public RSEWizardSelectionTreePatternFilter() {
        this(null);
    }

    public RSEWizardSelectionTreePatternFilter(WizardPage page) {
        this.parentPage = page;
    }

    protected WizardPage getParentWizardPage() {
        return this.parentPage;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        if (element instanceof RSENewConnectionWizardSelectionTreeElement) {
            IRSESystemType[] restricted;
            IRSESystemType systemType = ((RSENewConnectionWizardSelectionTreeElement)element).getSystemType();
            if (systemType == null) {
                return false;
            }
            WizardPage wizardPage = this.getParentWizardPage();
            if (wizardPage instanceof RSENewConnectionWizardSelectionPage && (restricted = ((RSENewConnectionWizardSelectionPage)wizardPage).getRestrictToSystemTypes()) != null && restricted.length > 0 && !Arrays.asList(restricted).contains(systemType)) {
                return false;
            }
            ViewerFilter filter = (ViewerFilter)systemType.getAdapter(ViewerFilter.class);
            if (filter != null && !filter.select(viewer, null, element)) {
                return false;
            }
            if (!systemType.isEnabled()) {
                return false;
            }
        }
        return super.isElementVisible(viewer, element);
    }

    public boolean isElementSelectable(Object element) {
        if (element instanceof RSEWizardSelectionTreeElement) {
            return !(((RSEWizardSelectionTreeElement)element).getWizardRegistryElement() instanceof IRSEWizardCategory);
        }
        return super.isElementSelectable(element);
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        RSEWizardSelectionTreeElement treeElement;
        if (element instanceof RSEWizardSelectionTreeElement && (treeElement = (RSEWizardSelectionTreeElement)element).getWizardRegistryElement() instanceof IRSEWizardDescriptor) {
            return this.wordMatches(treeElement.getLabel());
        }
        return super.isLeafMatch(viewer, element);
    }
}

