/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCreateGeneralProjectPage;
import org.eclipse.egit.ui.internal.clone.GitImportWizard;
import org.eclipse.egit.ui.internal.clone.GitProjectsImportPage;
import org.eclipse.egit.ui.internal.clone.GitSelectWizardPage;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.clone.ProjectUtils;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class GitCreateProjectViaWizardWizard
extends Wizard {
    private final Repository myRepository;
    private final String myGitDir;
    private GitSelectWizardPage mySelectionPage;
    private GitCreateGeneralProjectPage myCreateGeneralProjectPage;
    private GitProjectsImportPage myProjectsImportPage;

    public GitCreateProjectViaWizardWizard(Repository repository, String path) {
        this.myRepository = repository;
        this.myGitDir = path;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NLS.bind((String)UIText.GitCreateProjectViaWizardWizard_WizardTitle, (Object)this.myRepository.getDirectory().getPath()));
        this.setDialogSettings(GitImportWizard.getImportWizardDialogSettings());
    }

    public void addPages() {
        this.mySelectionPage = new GitSelectWizardPage(this.myRepository, this.myGitDir);
        this.addPage((IWizardPage)this.mySelectionPage);
        this.myCreateGeneralProjectPage = new GitCreateGeneralProjectPage(this.myGitDir){

            public void setVisible(boolean visible) {
                this.setPath(GitCreateProjectViaWizardWizard.this.mySelectionPage.getPath());
                super.setVisible(visible);
            }
        };
        this.addPage((IWizardPage)this.myCreateGeneralProjectPage);
        this.myProjectsImportPage = new GitProjectsImportPage(){

            public void setVisible(boolean visible) {
                this.setProjectsList(GitCreateProjectViaWizardWizard.this.mySelectionPage.getPath());
                super.setVisible(visible);
            }
        };
        this.addPage((IWizardPage)this.myProjectsImportPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mySelectionPage) {
            switch (this.mySelectionPage.getWizardSelection()) {
                case 0: {
                    return this.myProjectsImportPage;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.myCreateGeneralProjectPage;
                }
            }
            return super.getNextPage(page);
        }
        if (page == this.myCreateGeneralProjectPage || page == this.myProjectsImportPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        switch (this.mySelectionPage.getWizardSelection()) {
            case 0: {
                return this.myProjectsImportPage.isPageComplete();
            }
            case 1: {
                return true;
            }
            case 2: {
                return this.myCreateGeneralProjectPage.isPageComplete();
            }
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GitCreateProjectViaWizardWizard.this.importProjects(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getCause().getMessage(), e.getCause(), true);
            return false;
        }
        catch (InterruptedException e) {
            Activator.handleError(UIText.GitCreateProjectViaWizardWizard_AbortedMessage, e, true);
            return false;
        }
        return true;
    }

    private void importProjects(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        switch (this.mySelectionPage.getWizardSelection()) {
            case 0: {
                final HashSet<ProjectRecord> projectsToCreate = new HashSet<ProjectRecord>();
                final ArrayList workingSets = new ArrayList();
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        projectsToCreate.addAll(GitCreateProjectViaWizardWizard.this.myProjectsImportPage.getCheckedProjects());
                        IWorkingSet[] workingSetArray = GitCreateProjectViaWizardWizard.this.myProjectsImportPage.getSelectedWorkingSets();
                        workingSets.addAll(Arrays.asList(workingSetArray));
                        GitCreateProjectViaWizardWizard.this.myProjectsImportPage.saveWidgetValues();
                    }
                });
                ProjectUtils.createProjects(projectsToCreate, this.myRepository, workingSets.toArray(new IWorkingSet[workingSets.size()]), monitor);
                break;
            }
            case 1: {
                final List<IProject> previousProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
                    }
                });
                IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor actMonitor) throws CoreException {
                        IProject[] currentProjects;
                        IProject[] iProjectArray = currentProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = currentProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject current = iProjectArray[n2];
                            if (!previousProjects.contains(current)) {
                                ConnectProviderOperation cpo = new ConnectProviderOperation(current, GitCreateProjectViaWizardWizard.this.myRepository.getDirectory());
                                cpo.execute(actMonitor);
                            }
                            ++n2;
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(wsr, monitor);
                    break;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            case 2: {
                final String[] projectName = new String[1];
                final boolean[] defaultLocation = new boolean[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        projectName[0] = GitCreateProjectViaWizardWizard.this.myCreateGeneralProjectPage.getProjectName();
                        defaultLocation[0] = GitCreateProjectViaWizardWizard.this.myCreateGeneralProjectPage.isDefaultLocation();
                    }
                });
                try {
                    IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor actMonitor) throws CoreException {
                            IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName[0]);
                            if (!defaultLocation[0]) {
                                desc.setLocation((IPath)new Path(GitCreateProjectViaWizardWizard.this.myGitDir));
                            }
                            IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(desc.getName());
                            prj.create(desc, actMonitor);
                            prj.open(actMonitor);
                            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, actMonitor);
                            File repoDir = GitCreateProjectViaWizardWizard.this.myRepository.getDirectory();
                            ConnectProviderOperation cpo = new ConnectProviderOperation(prj, repoDir);
                            cpo.execute((IProgressMonitor)new NullProgressMonitor());
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(wsr, monitor);
                    break;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }
}

