/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtils {
    public static void createProjects(Set<ProjectRecord> projectsToCreate, Repository repository, IWorkingSet[] selectedWorkingSets, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ProjectUtils.createProjects(projectsToCreate, false, repository, selectedWorkingSets, monitor);
    }

    public static void createProjects(final Set<ProjectRecord> projectsToCreate, final boolean open, final Repository repository, final IWorkingSet[] selectedWorkingSets, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                try {
                    actMonitor.beginTask("", projectsToCreate.size());
                    if (actMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    for (ProjectRecord projectRecord : projectsToCreate) {
                        if (actMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        actMonitor.setTaskName(projectRecord.getProjectLabel());
                        IProject project = ProjectUtils.createExistingProject(projectRecord, open, (IProgressMonitor)new SubProgressMonitor(actMonitor, 1));
                        if (project == null) continue;
                        if (repository != null) {
                            ConnectProviderOperation connectProviderOperation = new ConnectProviderOperation(project, repository.getDirectory());
                            connectProviderOperation.execute(actMonitor);
                        }
                        if (selectedWorkingSets == null || selectedWorkingSets.length <= 0) continue;
                        workingSetManager.addToWorkingSets((IAdaptable)project, selectedWorkingSets);
                    }
                }
                finally {
                    actMonitor.done();
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsr, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static IProject createExistingProject(ProjectRecord record, boolean open, IProgressMonitor monitor) throws CoreException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            IPath location;
            if (open && !project.isOpen() && (location = project.getFile(".project").getLocation()) != null && location.toFile().equals(record.getProjectSystemFile())) {
                project.open(monitor);
                project.refreshLocal(2, monitor);
            }
            return null;
        }
        if (record.getProjectDescription() == null) {
            record.setProjectDescription(workspace.newProjectDescription(projectName));
            Path locationPath = new Path(record.getProjectSystemFile().getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.getProjectDescription().setLocation(null);
            } else {
                record.getProjectDescription().setLocation((IPath)locationPath);
            }
        } else {
            record.getProjectDescription().setName(projectName);
        }
        try {
            monitor.beginTask(UIText.WizardProjectsImportPage_CreateProjectsTask, 100);
            project.create(record.getProjectDescription(), (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            IProject iProject = project;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }
}

