/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;

public class MultiTypeDeclarationPattern
extends TypeDeclarationPattern {
    private char[][] fSimpleNames;
    private char[][] fQualifications;

    MultiTypeDeclarationPattern(int matchRule) {
        super(matchRule);
    }

    public MultiTypeDeclarationPattern(char[][] qualifications, char[][] simpleNames, int matchRule) {
        this(matchRule);
        int i;
        int length;
        if (this.isCaseSensitive() || qualifications == null) {
            this.fQualifications = qualifications;
        } else {
            length = qualifications.length;
            this.fQualifications = new char[length][];
            i = 0;
            while (i < length) {
                this.fQualifications[i] = CharOperation.toLowerCase(qualifications[i]);
                ++i;
            }
        }
        if (simpleNames != null) {
            if (this.isCaseSensitive() || this.isCamelCase()) {
                this.fSimpleNames = simpleNames;
            } else {
                length = simpleNames.length;
                this.fSimpleNames = new char[length][];
                i = 0;
                while (i < length) {
                    this.fSimpleNames[i] = CharOperation.toLowerCase(simpleNames[i]);
                    ++i;
                }
            }
        }
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        boolean foundMatch = false;
        int typesLength = this.getTypesLength();
        int i = 0;
        while (i < typesLength && !foundMatch) {
            this.simpleName = (char[])(this.fSimpleNames != null && this.fSimpleNames.length > i ? this.fSimpleNames[i] : null);
            this.qualification = (char[])(this.fQualifications != null && this.fQualifications.length > i ? this.fQualifications[i] : null);
            foundMatch = super.matchesDecodedKey(decodedPattern);
            ++i;
        }
        this.simpleName = null;
        this.qualification = null;
        return foundMatch;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        EntryResult[] results = null;
        int typesLength = this.getTypesLength();
        int i = 0;
        while (i < typesLength) {
            this.simpleName = (char[])(this.fSimpleNames != null && this.fSimpleNames.length > i ? this.fSimpleNames[i] : null);
            this.qualification = (char[])(this.fQualifications != null && this.fQualifications.length > i ? this.fQualifications[i] : null);
            EntryResult[] additionalResults = super.queryIn(index);
            if (additionalResults != null && additionalResults.length > 0) {
                if (results == null) {
                    results = additionalResults;
                } else {
                    EntryResult[] existingResults = results;
                    results = new EntryResult[existingResults.length + additionalResults.length];
                    System.arraycopy(existingResults, 0, results, 0, existingResults.length);
                    System.arraycopy(additionalResults, 0, results, existingResults.length, additionalResults.length);
                }
            }
            ++i;
        }
        this.simpleName = null;
        this.qualification = null;
        return results;
    }

    protected StringBuffer print(StringBuffer output) {
        int i;
        output.append("MultiTypeDeclarationPattern: ");
        if (this.fQualifications != null) {
            output.append("qualifications: <");
            i = 0;
            while (i < this.fQualifications.length) {
                output.append(this.fQualifications[i]);
                if (i < this.fQualifications.length - 1) {
                    output.append(", ");
                }
                ++i;
            }
            output.append("> ");
        }
        if (this.fSimpleNames != null) {
            output.append("simpleNames: <");
            i = 0;
            while (i < this.fSimpleNames.length) {
                output.append(this.fSimpleNames[i]);
                if (i < this.fSimpleNames.length - 1) {
                    output.append(", ");
                }
                ++i;
            }
            output.append(">");
        }
        return super.print(output);
    }

    private int getTypesLength() {
        int length = 0;
        if (this.fSimpleNames != null && this.fQualifications != null) {
            length = this.fSimpleNames.length > this.fQualifications.length ? this.fSimpleNames.length : this.fQualifications.length;
        } else if (this.fSimpleNames != null) {
            length = this.fSimpleNames.length;
        } else if (this.fQualifications != null) {
            length = this.fQualifications.length;
        }
        return length;
    }
}

