/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.model;

import com.liferay.ide.layouttpl.core.model.LayoutTplDiagramElement;
import com.liferay.ide.layouttpl.core.model.ModelElement;
import com.liferay.ide.layouttpl.core.model.PortletColumnElement;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRowLayoutElement
extends ModelElement
implements PropertyChangeListener {
    public static final String ROW_ADDED_PROP = "LayoutTplDiagram.RowAdded";
    public static final String ROW_REMOVED_PROP = "LayoutTplDiagram.RowRemoved";
    protected List<ModelElement> rows = new ArrayList<ModelElement>();

    public void addRow(PortletLayoutElement newRow) {
        this.addRow(newRow, -1);
    }

    public boolean addRow(PortletLayoutElement newRow, int index) {
        if (newRow != null) {
            if (index < 0) {
                this.rows.add(newRow);
            } else {
                this.rows.add(index, newRow);
            }
            newRow.setParent(this);
            newRow.addPropertyChangeListener(this);
            this.updateColumns();
            this.firePropertyChange(ROW_ADDED_PROP, null, newRow);
            return true;
        }
        return false;
    }

    public List<ModelElement> getRows() {
        return this.rows;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("PortletLayout.ColumnAdded".equals(prop) || "PortletLayout.ColumnRemoved".equals(prop)) {
            this.updateColumns();
        }
    }

    @Override
    public void removeChild(ModelElement child) {
        if (this.rows.contains(child)) {
            this.removeRow((PortletLayoutElement)child);
        }
    }

    public boolean removeRow(PortletLayoutElement existingRow) {
        if (existingRow != null && this.rows.remove(existingRow)) {
            this.firePropertyChange(ROW_REMOVED_PROP, null, existingRow);
            return true;
        }
        return false;
    }

    protected void updateColumns() {
        ModelElement diagram = this;
        while (diagram != null && !(diagram instanceof LayoutTplDiagramElement)) {
            diagram = diagram.getParent();
        }
        if (diagram instanceof LayoutTplDiagramElement) {
            ((LayoutTplDiagramElement)diagram).updateColumns(1);
        } else {
            this.updateColumns(1);
        }
    }

    protected int updateColumns(int numIdCount) {
        for (ModelElement row : this.getRows()) {
            List<ModelElement> cols = ((PortletLayoutElement)row).getColumns();
            int i = 0;
            while (i < cols.size()) {
                PortletColumnElement col = (PortletColumnElement)cols.get(i);
                if (col.getRows().isEmpty()) {
                    col.setNumId(numIdCount++);
                } else {
                    numIdCount = col.updateColumns(numIdCount++);
                }
                if (i == 0 && cols.size() > 1) {
                    col.setFirst(true);
                    col.setLast(false);
                } else if (cols.size() > 1 && i == cols.size() - 1) {
                    col.setLast(true);
                    col.setFirst(false);
                } else {
                    col.setFirst(false);
                    col.setLast(false);
                }
                ++i;
            }
        }
        return numIdCount;
    }
}

