/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.Capability;

public class MavenCapability
extends Capability {
    private static final long serialVersionUID = 8930981127331238566L;
    public static final String NS_MAVEN_ARTIFACT = "maven-artifact";
    public static final String NS_MAVEN_PARENT = "maven-parent";
    private final String version;

    private MavenCapability(String namespace, String id, String version) {
        super(namespace, id);
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.valueOf(this.getVersionlessKey().toString()) + "/" + this.version;
    }

    public int hashCode() {
        int hash = this.getVersionlessKey().hashCode();
        hash = hash * 17 + this.version.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MavenCapability)) {
            return false;
        }
        MavenCapability other = (MavenCapability)obj;
        return this.getVersionlessKey().equals(other.getVersionlessKey()) && this.version.equals(other.version);
    }

    public static MavenCapability createMavenArtifact(ArtifactKey key) {
        return new MavenCapability(NS_MAVEN_ARTIFACT, MavenCapability.getId(key), key.getVersion());
    }

    public static MavenCapability createMavenParent(ArtifactKey key) {
        return new MavenCapability(NS_MAVEN_PARENT, MavenCapability.getId(key), key.getVersion());
    }

    static String getId(ArtifactKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append(key.getGroupId());
        sb.append(':').append(key.getArtifactId());
        if (key.getClassifier() != null) {
            sb.append(':').append(key.getClassifier());
        }
        return sb.toString();
    }
}

