/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRegistryAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlRegistry
extends AbstractJavaContextNode
implements XmlRegistry {
    protected final ElementFactoryMethodContainer elementFactoryMethodContainer = new ElementFactoryMethodContainer();
    protected static final Predicate<JavaResourceMethod> METHOD_IS_ELEMENT_FACTORY_METHOD = new MethodIsElementFactoryMethod();

    public GenericJavaXmlRegistry(JavaClass parent) {
        super(parent);
        this.initElementFactoryMethods();
    }

    @Override
    public JavaClass getJaxbClass() {
        return (JavaClass)this.getParent();
    }

    public JavaResourceType getJavaResourceType() {
        return this.getJaxbClass().getJavaResourceType();
    }

    protected XmlRegistryAnnotation getAnnotation() {
        return (XmlRegistryAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlRegistry");
    }

    public JaxbPackage getJaxbPackage() {
        return this.getJaxbClass().getJaxbPackage();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncElementFactoryMethods();
    }

    @Override
    public void update() {
        super.update();
        this.updateElementFactoryMethods();
    }

    @Override
    public Iterable<JaxbElementFactoryMethod> getElementFactoryMethods() {
        return this.elementFactoryMethodContainer.getContextElements();
    }

    @Override
    public int getElementFactoryMethodsSize() {
        return this.elementFactoryMethodContainer.getContextElementsSize();
    }

    protected void initElementFactoryMethods() {
        this.elementFactoryMethodContainer.initialize();
    }

    protected void syncElementFactoryMethods() {
        this.elementFactoryMethodContainer.synchronizeWithResourceModel();
    }

    protected void updateElementFactoryMethods() {
        this.elementFactoryMethodContainer.update();
    }

    private JaxbElementFactoryMethod buildElementFactoryMethod(JavaResourceMethod resourceMethod) {
        return this.getFactory().buildJavaElementFactoryMethod(this, resourceMethod);
    }

    private Iterable<JavaResourceMethod> getResourceElementFactoryMethods() {
        return IterableTools.filter((Iterable)this.getJavaResourceType().getMethods(), METHOD_IS_ELEMENT_FACTORY_METHOD);
    }

    protected static boolean methodReturnTypeIsJAXBElement(JavaResourceMethod method) {
        return method.getTypeBinding().isSubTypeOf("javax.xml.bind.annotation.XmlElement");
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        for (JaxbElementFactoryMethod efm : this.getElementFactoryMethods()) {
            result = efm.getCompletionProposals(pos);
            if (IterableTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotation().getTextRange();
        return textRange != null ? textRange : this.getJaxbClass().getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        Iterable<XmlRegistry> registries = this.getContextRoot().getXmlRegistries(this.getJaxbPackage());
        if (IterableTools.size(registries) > 1) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_REGISTRY__MULTIPLE_XML_REGISTRIES_FOR_PACKAGE));
        }
        this.validateDuplicateQNames(messages, reporter);
        for (JaxbElementFactoryMethod efm : this.getElementFactoryMethods()) {
            efm.validate(messages, reporter);
        }
    }

    protected void validateDuplicateQNames(List<IMessage> messages, IReporter reporter) {
        HashMap<String, HashBag> xmlElementDeclQnames = new HashMap<String, HashBag>();
        for (JaxbElementFactoryMethod xmlElementDecl : this.getElementFactoryMethods()) {
            String elementDeclName = xmlElementDecl.getQName().getName();
            if (StringTools.isBlank((String)elementDeclName)) continue;
            String fqScope = xmlElementDecl.getFullyQualifiedScope();
            if (xmlElementDeclQnames.get(fqScope) == null) {
                xmlElementDeclQnames.put(fqScope, new HashBag());
            }
            ((Bag)xmlElementDeclQnames.get(fqScope)).add((Object)new QName(xmlElementDecl.getQName().getNamespace(), elementDeclName));
        }
        for (JaxbElementFactoryMethod xmlElementDecl : this.getElementFactoryMethods()) {
            String fqScope = xmlElementDecl.getFullyQualifiedScope();
            String xmlElementNamespace = xmlElementDecl.getQName().getNamespace();
            String xmlElementName = xmlElementDecl.getQName().getName();
            if (((Bag)xmlElementDeclQnames.get(fqScope)).count((Object)new QName(xmlElementNamespace, xmlElementName)) <= 1) continue;
            String scopeDesc = "";
            if (!"javax.xml.bind.annotation.XmlElementDecl.GLOBAL".equals(fqScope)) {
                scopeDesc = NLS.bind((String)JptJaxbCoreMessages.XML_ELEMENT_DECL__SCOPE, (Object)fqScope);
            }
            messages.add(this.buildValidationMessage((JaxbNode)xmlElementDecl, xmlElementDecl.getQName().getNameValidationTextRange(), JptJaxbCoreValidationMessages.XML_REGISTRY__DUPLICATE_XML_ELEMENT_QNAME, xmlElementName, scopeDesc));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementFactoryMethodContainer
    extends AbstractJaxbNode.ContextCollectionContainer<JaxbElementFactoryMethod, JavaResourceMethod> {
        protected ElementFactoryMethodContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "elementFactoryMethods";
        }

        @Override
        protected JaxbElementFactoryMethod buildContextElement(JavaResourceMethod resourceElement) {
            return GenericJavaXmlRegistry.this.buildElementFactoryMethod(resourceElement);
        }

        @Override
        protected Iterable<JavaResourceMethod> getResourceElements() {
            return GenericJavaXmlRegistry.this.getResourceElementFactoryMethods();
        }

        @Override
        protected JavaResourceMethod getResourceElement(JaxbElementFactoryMethod contextElement) {
            return contextElement.getResourceMethod();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodIsElementFactoryMethod
    extends PredicateAdapter<JavaResourceMethod> {
        public boolean evaluate(JavaResourceMethod method) {
            return method.getAnnotation("javax.xml.bind.annotation.XmlElementDecl") != null;
        }
    }
}

